/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.parser;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.formula.Formula;
import net.sf.jxls.parser.Property;
import net.sf.jxls.tag.Tag;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.transformer.RowCollection;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.hssf.util.CellReference;

public class Cell {
    private Row row;
    private Property collectionProperty;
    private HSSFCell hssfCell;
    private Formula formula;
    private String label;
    private int dependentRowNumber;
    private String collectionName;
    private String hssfCellValue;
    private String stringCellValue;
    private String metaInfo;
    private CellRangeAddress mergedRegion;
    private List expressions = new ArrayList();
    private Tag tag;
    private RowCollection rowCollection;

    public Cell(HSSFCell hssfCell, Row row) {
        this.setHssfCell(hssfCell);
        this.setRow(row);
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List expressions) {
        this.expressions = expressions;
    }

    public CellRangeAddress getMergedRegion() {
        return this.mergedRegion;
    }

    public int getDependentRowNumber() {
        return this.dependentRowNumber;
    }

    public RowCollection getRowCollection() {
        return this.rowCollection;
    }

    public void setRowCollection(RowCollection rowCollection) {
        this.rowCollection = rowCollection;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Formula getFormula() {
        return this.formula;
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Property getCollectionProperty() {
        return this.collectionProperty;
    }

    public void setCollectionProperty(Property collectionProperty) {
        this.collectionProperty = collectionProperty;
    }

    public HSSFCell getHssfCell() {
        return this.hssfCell;
    }

    public void setHssfCell(HSSFCell hssfCell) {
        this.hssfCell = hssfCell;
    }

    public String toCellName() {
        CellReference cellRef = new CellReference(this.getRow().getHssfRow().getRowNum(), this.getHssfCell().getColumnIndex(), false, false);
        return cellRef.formatAsString();
    }

    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public boolean isFormula() {
        return this.getFormula() != null;
    }

    public String getHssfCellValue() {
        return this.hssfCellValue;
    }

    public String getStringCellValue() {
        return this.stringCellValue;
    }

    public String getMetaInfo() {
        return this.metaInfo;
    }

    public boolean isEmpty() {
        return this.getHssfCellValue() == null || this.getHssfCellValue().length() == 0 || this.getHssfCell().getCellType() == 3;
    }

    public boolean isNull() {
        return this.getHssfCell() == null;
    }

    public String toString() {
        return this.getHssfCellValue();
    }

    public void setDependentRowNumber(int dependentRowNumber) {
        this.dependentRowNumber = dependentRowNumber;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setHssfCellValue(String hssfCellValue) {
        this.hssfCellValue = hssfCellValue;
    }

    public void setStringCellValue(String stringCellValue) {
        this.stringCellValue = stringCellValue;
    }

    public void setMetaInfo(String metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setMergedRegion(CellRangeAddress mergedRegion) {
        this.mergedRegion = mergedRegion;
    }
}

