/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.jms.JMSConduit;
import org.apache.cxf.transport.jms.JMSDestination;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory {
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    private Bus bus;

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    public Conduit getConduit(EndpointInfo targetInfo) throws IOException {
        return this.getConduit(targetInfo, targetInfo.getTarget());
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        JMSConduit conduit = target == null ? new JMSConduit(this.bus, endpointInfo) : new JMSConduit(this.bus, endpointInfo, target);
        return conduit;
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        JMSDestination destination = new JMSDestination(this.bus, this, endpointInfo);
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean((Object)destination);
        }
        return destination;
    }

    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    static {
        URI_PREFIXES.add("jms://");
    }
}

