/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBElement;
import org.apache.cxf.common.util.WeakIdentityHashMap;
import org.apache.cxf.jaxws.interceptors.WrapperHelper;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WrapperHelperCompiler {
    private static final Map<Class<?>, TypeHelperClassLoader> LOADER_MAP = new WeakIdentityHashMap();
    private static final Map<Class<?>, String> PRIMITIVE_MAP = new HashMap();
    private static final Map<Class<?>, String> NONPRIMITIVE_MAP = new HashMap();
    private static boolean oldASM;
    final Class<?> wrapperType;
    final Method[] setMethods;
    final Method[] getMethods;
    final Method[] jaxbMethods;
    final Field[] fields;
    final Object objectFactory;
    final ClassWriter cw;

    private WrapperHelperCompiler(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        this.wrapperType = wrapperType;
        this.setMethods = setMethods;
        this.getMethods = getMethods;
        this.jaxbMethods = jaxbMethods;
        this.fields = fields;
        this.objectFactory = objectFactory;
        ClassWriter newCw = null;
        if (!oldASM) {
            Class<ClassWriter> cls = ClassWriter.class;
            try {
                Constructor cons = cls.getConstructor(Boolean.TYPE);
                try {
                    cls.getMethod("newConstInt", Integer.TYPE);
                    newCw = null;
                    oldASM = true;
                }
                catch (Throwable t) {
                    newCw = (ClassWriter)cons.newInstance(Boolean.TRUE);
                }
            }
            catch (Throwable e) {
                try {
                    Constructor cons = cls.getConstructor(Integer.TYPE);
                    int i = cls.getField("COMPUTE_MAXS").getInt(null);
                    newCw = (ClassWriter)cons.newInstance(i |= cls.getField("COMPUTE_FRAMES").getInt(null));
                }
                catch (Throwable e1) {
                    // empty catch block
                }
            }
        }
        this.cw = newCw;
    }

    static WrapperHelper compileWrapperHelper(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        try {
            return new WrapperHelperCompiler(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory).compile();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public WrapperHelper compile() {
        if (this.cw == null) {
            return null;
        }
        int count = 1;
        String newClassName = this.wrapperType.getName() + "_WrapperTypeHelper" + count;
        newClassName = newClassName.replaceAll("\\$", ".");
        newClassName = WrapperHelperCompiler.periodToSlashes(newClassName);
        Class<?> cls = this.findClass(newClassName.replace('/', '.'), this.wrapperType);
        while (cls != null) {
            try {
                WrapperHelper helper = (WrapperHelper)WrapperHelper.class.cast(cls.newInstance());
                if (!helper.getSignature().equals(this.computeSignature())) {
                    newClassName = this.wrapperType.getName() + "_WrapperTypeHelper" + ++count;
                    newClassName = newClassName.replaceAll("\\$", ".");
                    newClassName = WrapperHelperCompiler.periodToSlashes(newClassName);
                    cls = this.findClass(newClassName.replace('/', '.'), this.wrapperType);
                    continue;
                }
                return helper;
            }
            catch (Exception e) {
                return null;
            }
        }
        this.cw.visit(49, 33, newClassName, null, WrapperHelperCompiler.periodToSlashes(WrapperHelper.class.getName()), null);
        WrapperHelperCompiler.addConstructor(newClassName, this.cw, this.objectFactory == null ? null : this.objectFactory.getClass());
        boolean b = this.addSignature();
        if (b) {
            this.addCreateWrapperObject(newClassName, this.objectFactory == null ? null : this.objectFactory.getClass());
        }
        if (b) {
            b = WrapperHelperCompiler.addGetWrapperParts(newClassName, this.wrapperType, this.getMethods, this.fields, this.cw);
        }
        try {
            if (b) {
                this.cw.visitEnd();
                byte[] bt = this.cw.toByteArray();
                Class<?> cl = new TypeHelperClassLoader(this.wrapperType.getClassLoader()).defineClass(newClassName.replaceAll("/", "."), bt);
                Object o = cl.newInstance();
                return (WrapperHelper)WrapperHelper.class.cast(o);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return null;
    }

    private String computeSignature() {
        StringBuilder b = new StringBuilder();
        b.append(this.setMethods.length).append(':');
        for (int x = 0; x < this.setMethods.length; ++x) {
            if (this.getMethods[x] == null) {
                b.append("null,");
                continue;
            }
            b.append(this.getMethods[x].getName()).append('/');
            b.append(this.getMethods[x].getReturnType().getName()).append(',');
        }
        return b.toString();
    }

    private boolean addSignature() {
        String sig = this.computeSignature();
        if (sig == null) {
            return false;
        }
        MethodVisitor mv = this.cw.visitMethod(1, "getSignature", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(100, l0);
        mv.visitLdcInsn((Object)sig);
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(101, l1);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return true;
    }

    private static void addConstructor(String newClassName, ClassWriter cw, Class<?> objectFactory) {
        if (objectFactory != null) {
            String ofName = "L" + WrapperHelperCompiler.periodToSlashes(objectFactory.getName()) + ";";
            FieldVisitor fv = cw.visitField(0, "factory", ofName, null, null);
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(102, l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, WrapperHelperCompiler.periodToSlashes(WrapperHelper.class.getName()), "<init>", "()V");
        if (objectFactory != null) {
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, WrapperHelperCompiler.periodToSlashes(objectFactory.getName()));
            mv.visitInsn(89);
            mv.visitMethodInsn(183, WrapperHelperCompiler.periodToSlashes(objectFactory.getName()), "<init>", "()V");
            mv.visitFieldInsn(181, WrapperHelperCompiler.periodToSlashes(newClassName), "factory", "L" + WrapperHelperCompiler.periodToSlashes(objectFactory.getName()) + ";");
        }
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(103, l0);
        mv.visitLocalVariable("this", "L" + newClassName + ";", null, l0, l1, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private boolean addCreateWrapperObject(String newClassName, Class<?> objectFactoryClass) {
        MethodVisitor mv = this.cw.visitMethod(1, "createWrapperObject", "(Ljava/util/List;)Ljava/lang/Object;", "(Ljava/util/List<*>;)Ljava/lang/Object;", new String[]{"org/apache/cxf/interceptor/Fault"});
        mv.visitCode();
        Label lBegin = new Label();
        mv.visitLabel(lBegin);
        mv.visitLineNumber(104, lBegin);
        mv.visitTypeInsn(187, WrapperHelperCompiler.periodToSlashes(this.wrapperType.getName()));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, WrapperHelperCompiler.periodToSlashes(this.wrapperType.getName()), "<init>", "()V");
        mv.visitVarInsn(58, 2);
        for (int x = 0; x < this.setMethods.length; ++x) {
            if (this.getMethods[x] == null) {
                if (this.setMethods[x] == null && this.fields[x] == null) continue;
                return false;
            }
            Class<?> tp = this.getMethods[x].getReturnType();
            mv.visitVarInsn(25, 2);
            if (List.class.isAssignableFrom(tp)) {
                this.doCollection(mv, x);
                continue;
            }
            if (JAXBElement.class.isAssignableFrom(tp)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, WrapperHelperCompiler.periodToSlashes(newClassName), "factory", "L" + WrapperHelperCompiler.periodToSlashes(objectFactoryClass.getName()) + ";");
            }
            mv.visitVarInsn(25, 1);
            mv.visitIntInsn(16, x);
            mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            if (tp.isPrimitive()) {
                mv.visitTypeInsn(192, NONPRIMITIVE_MAP.get(tp));
                mv.visitMethodInsn(182, NONPRIMITIVE_MAP.get(tp), tp.getName() + "Value", "()" + PRIMITIVE_MAP.get(tp));
            } else if (JAXBElement.class.isAssignableFrom(tp)) {
                mv.visitTypeInsn(192, WrapperHelperCompiler.periodToSlashes(this.jaxbMethods[x].getParameterTypes()[0].getName()));
                mv.visitMethodInsn(182, WrapperHelperCompiler.periodToSlashes(objectFactoryClass.getName()), this.jaxbMethods[x].getName(), WrapperHelperCompiler.getMethodSignature(this.jaxbMethods[x]));
            } else if (tp.isArray()) {
                mv.visitTypeInsn(192, WrapperHelperCompiler.getClassCode(tp));
            } else {
                mv.visitTypeInsn(192, WrapperHelperCompiler.periodToSlashes(tp.getName()));
            }
            mv.visitMethodInsn(182, WrapperHelperCompiler.periodToSlashes(this.wrapperType.getName()), this.setMethods[x].getName(), "(" + WrapperHelperCompiler.getClassCode(tp) + ")V");
        }
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        Label lEnd = new Label();
        mv.visitLabel(lEnd);
        mv.visitLineNumber(105, lEnd);
        mv.visitLocalVariable("this", "L" + newClassName + ";", null, lBegin, lEnd, 0);
        mv.visitLocalVariable("lst", "Ljava/util/List;", "Ljava/util/List<*>;", lBegin, lEnd, 1);
        mv.visitLocalVariable("ok", "L" + WrapperHelperCompiler.periodToSlashes(this.wrapperType.getName()) + ";", null, lBegin, lEnd, 2);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return true;
    }

    private void doCollection(MethodVisitor mv, int x) {
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLineNumber(114, l3);
        mv.visitMethodInsn(182, WrapperHelperCompiler.periodToSlashes(this.wrapperType.getName()), this.getMethods[x].getName(), WrapperHelperCompiler.getMethodSignature(this.getMethods[x]));
        mv.visitVarInsn(58, 3);
        mv.visitVarInsn(25, 1);
        mv.visitIntInsn(16, x);
        mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "java/util/List");
        mv.visitVarInsn(58, 4);
        mv.visitVarInsn(25, 3);
        Label nonNullLabel = new Label();
        mv.visitJumpInsn(199, nonNullLabel);
        if (this.setMethods[x] == null) {
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)(this.getMethods[x].getName() + " returned null and there isn't a set method."));
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
        } else {
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 4);
            mv.visitTypeInsn(192, this.getMethods[x].getReturnType().getName().replace('.', '/'));
            mv.visitMethodInsn(182, WrapperHelperCompiler.periodToSlashes(this.wrapperType.getName()), this.setMethods[x].getName(), WrapperHelperCompiler.getMethodSignature(this.setMethods[x]));
        }
        Label jumpOverLabel = new Label();
        mv.visitJumpInsn(167, jumpOverLabel);
        mv.visitLabel(nonNullLabel);
        mv.visitLineNumber(106, nonNullLabel);
        mv.visitVarInsn(25, 4);
        mv.visitJumpInsn(198, jumpOverLabel);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(185, "java/util/List", "addAll", "(Ljava/util/Collection;)Z");
        mv.visitInsn(87);
        mv.visitLabel(jumpOverLabel);
        mv.visitLineNumber(107, jumpOverLabel);
    }

    private static boolean addGetWrapperParts(String newClassName, Class<?> wrapperClass, Method[] getMethods, Field[] fields, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "getWrapperParts", "(Ljava/lang/Object;)Ljava/util/List;", "(Ljava/lang/Object;)Ljava/util/List<Ljava/lang/Object;>;", new String[]{"org/apache/cxf/interceptor/Fault"});
        mv.visitCode();
        Label lBegin = new Label();
        mv.visitLabel(lBegin);
        mv.visitLineNumber(108, lBegin);
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, WrapperHelperCompiler.periodToSlashes(wrapperClass.getName()));
        mv.visitVarInsn(58, 3);
        for (int x = 0; x < getMethods.length; ++x) {
            Label l3;
            Method method = getMethods[x];
            if (method == null && fields[x] != null) {
                return false;
            }
            if (method == null) {
                l3 = new Label();
                mv.visitLabel(l3);
                mv.visitLineNumber(200 + x, l3);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(1);
                mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
                mv.visitInsn(87);
                continue;
            }
            l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLineNumber(250 + x, l3);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, WrapperHelperCompiler.periodToSlashes(wrapperClass.getName()), method.getName(), WrapperHelperCompiler.getMethodSignature(method));
            if (method.getReturnType().isPrimitive()) {
                WrapperHelperCompiler.createObjectWrapper(mv, method.getReturnType());
            }
            if (JAXBElement.class.isAssignableFrom(method.getReturnType())) {
                mv.visitMethodInsn(182, "javax/xml/bind/JAXBElement", "getValue", "()Ljava/lang/Object;");
            }
            mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
        }
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(108, l2);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        Label lEnd = new Label();
        mv.visitLabel(lEnd);
        mv.visitLineNumber(109, lEnd);
        mv.visitLocalVariable("this", "L" + newClassName + ";", null, lBegin, lEnd, 0);
        mv.visitLocalVariable("o", "Ljava/lang/Object;", null, lBegin, lEnd, 1);
        mv.visitLocalVariable("ret", "Ljava/util/List;", "Ljava/util/List<Ljava/lang/Object;>;", lBegin, lEnd, 2);
        mv.visitLocalVariable("ok", "L" + WrapperHelperCompiler.periodToSlashes(wrapperClass.getName()) + ";", null, lBegin, lEnd, 3);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return true;
    }

    private static String getMethodSignature(Method m) {
        StringBuffer buf = new StringBuffer("(");
        for (Class<?> cl : m.getParameterTypes()) {
            buf.append(WrapperHelperCompiler.getClassCode(cl));
        }
        buf.append(")");
        buf.append(WrapperHelperCompiler.getClassCode(m.getReturnType()));
        return buf.toString();
    }

    private static String getClassCode(Class<?> cl) {
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isPrimitive()) {
            return PRIMITIVE_MAP.get(cl);
        }
        if (cl.isArray()) {
            return "[" + WrapperHelperCompiler.getClassCode(cl.getComponentType());
        }
        return "L" + WrapperHelperCompiler.periodToSlashes(cl.getName()) + ";";
    }

    private static void createObjectWrapper(MethodVisitor mv, Class<?> cl) {
        mv.visitMethodInsn(184, NONPRIMITIVE_MAP.get(cl), "valueOf", "(" + PRIMITIVE_MAP.get(cl) + ")L" + NONPRIMITIVE_MAP.get(cl) + ";");
    }

    private static String periodToSlashes(String s) {
        char[] ch = s.toCharArray();
        for (int x = 0; x < ch.length; ++x) {
            if (ch[x] != '.') continue;
            ch[x] = 47;
        }
        return new String(ch);
    }

    public Class<?> loadClass(String className, Class clz, byte[] bytes) {
        TypeHelperClassLoader loader = WrapperHelperCompiler.getTypeHelperClassLoader(clz);
        return loader.defineClass(className, bytes);
    }

    public Class<?> findClass(String className, Class clz) {
        TypeHelperClassLoader loader = WrapperHelperCompiler.getTypeHelperClassLoader(clz);
        return loader.lookupDefinedClass(className);
    }

    private static synchronized TypeHelperClassLoader getTypeHelperClassLoader(Class<?> l) {
        TypeHelperClassLoader ret = LOADER_MAP.get(l);
        if (ret == null) {
            ret = new TypeHelperClassLoader(l.getClassLoader());
            LOADER_MAP.put(l, ret);
        }
        return ret;
    }

    static {
        PRIMITIVE_MAP.put(Byte.TYPE, "B");
        PRIMITIVE_MAP.put(Boolean.TYPE, "Z");
        PRIMITIVE_MAP.put(Long.TYPE, "J");
        PRIMITIVE_MAP.put(Integer.TYPE, "I");
        PRIMITIVE_MAP.put(Short.TYPE, "S");
        PRIMITIVE_MAP.put(Character.TYPE, "C");
        PRIMITIVE_MAP.put(Float.TYPE, "F");
        PRIMITIVE_MAP.put(Double.TYPE, "D");
        NONPRIMITIVE_MAP.put(Byte.TYPE, Byte.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Boolean.TYPE, Boolean.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Long.TYPE, Long.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Integer.TYPE, Integer.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Short.TYPE, Short.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Character.TYPE, Character.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Float.TYPE, Float.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Double.TYPE, Double.class.getName().replaceAll("\\.", "/"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeHelperClassLoader
    extends ClassLoader {
        Map<String, Class<?>> defined = new ConcurrentHashMap();

        TypeHelperClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> lookupDefinedClass(String name) {
            return this.defined.get(name);
        }

        public Class<?> defineClass(String name, byte[] bytes) {
            Package p;
            if (name.endsWith("package-info") && (p = super.getPackage(name.substring(0, name.length() - 13))) == null) {
                this.definePackage(name.substring(0, name.length() - 13).replace('/', '.'), null, null, null, null, null, null, null);
            }
            Class<?> ret = super.defineClass(name.replace('/', '.'), bytes, 0, bytes.length);
            this.defined.put(name, ret);
            return ret;
        }
    }
}

