/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationDispatcher;
import org.jmock.core.Invokable;
import org.jmock.core.Stub;
import org.jmock.core.Verifiable;
import org.jmock.core.stub.TestFailureStub;

public class FIFOInvocationDispatcher
implements InvocationDispatcher {
    public static final String NO_EXPECTATIONS_MESSAGE = "No expectations set";
    private ArrayList invokables = new ArrayList();
    private Stub defaultStub = new TestFailureStub("no match found");

    public Object dispatch(Invocation invocation) throws Throwable {
        ListIterator listIterator = this.invokables.listIterator();
        while (listIterator.hasNext()) {
            Invokable invokable = (Invokable)listIterator.next();
            if (!invokable.matches(invocation)) continue;
            return invokable.invoke(invocation);
        }
        return this.defaultStub.invoke(invocation);
    }

    public void setDefaultStub(Stub stub) {
        this.defaultStub = stub;
    }

    public void add(Invokable invokable) {
        this.invokables.add(invokable);
    }

    public void verify() {
        Iterator iterator = this.invokables.iterator();
        while (iterator.hasNext()) {
            ((Verifiable)iterator.next()).verify();
        }
    }

    public void clear() {
        this.invokables.clear();
    }

    public StringBuffer describeTo(StringBuffer stringBuffer) {
        if (this.anyInvokableHasDescription()) {
            this.writeInvokablesTo(stringBuffer);
        } else {
            stringBuffer.append(NO_EXPECTATIONS_MESSAGE);
        }
        return stringBuffer;
    }

    private void writeInvokablesTo(StringBuffer stringBuffer) {
        Iterator iterator = this.invokables.iterator();
        while (iterator.hasNext()) {
            Invokable invokable = (Invokable)iterator.next();
            if (!invokable.hasDescription()) continue;
            invokable.describeTo(stringBuffer).append("\n");
        }
    }

    private boolean anyInvokableHasDescription() {
        Iterator iterator = this.invokables.iterator();
        while (iterator.hasNext()) {
            if (!((Invokable)iterator.next()).hasDescription()) continue;
            return true;
        }
        return false;
    }
}

