/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.jms.JMSException;
import jeus.jms.client.comm.JMSServerEntryContext;
import jeus.jms.client.facility.connection.JeusConnection;
import jeus.jms.common.JMSBaseEntry;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MessageHandleEvent;
import jeus.jms.common.message.admin.TakeoverMessage;
import jeus.jms.common.util.JMSSyncRequest;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.common.util.PropertyUtil;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS2;

public abstract class JMSServerEntry
extends JMSBaseEntry
implements MessageHandler {
    private static final String ENTRY_PREFIX = "MQClient-";
    public static final int DEFAULT_MIN_THREAD = 10;
    public static final int DEFAULT_MAX_THREAD = 100;
    public static long UTC_OFFSET = TimeZone.getDefault().getRawOffset();
    public static boolean RI_COMPATIBLE = PropertyUtil.getBooleanProperty("cts.interop", false);
    public static boolean DISABLE_NAGLE_ALGORITHM = PropertyUtil.getBooleanProperty("jeus.jms.client.nagle", false);
    public static long TX_MESSAGE_TIMEOUT = PropertyUtil.getLongProperty("jeus.jms.client.tx.timeout", 60000L);
    public static long ADMIN_MESSAGE_TIMEOUT = PropertyUtil.getLongProperty("jeus.jms.client.admin.timeout", 200000L);
    public static long SHUTDOWN_MESSAGE_TIMEOUT = PropertyUtil.getLongProperty("jeus.jms.client.shutdown.timeout", 10000L);
    public static long RECONNECT_MIN_INTERVAL = PropertyUtil.getLongProperty("jeus.jms.client.reconnect.interval", 3000L);
    public static int DEFAULT_REDELIVERY_LIMIT = PropertyUtil.getIntProperty("jeus.jms.client.defaultRedeliveryLimit", 3);
    public static boolean USE_COMPRESS;
    public static int COMPRESS_THRESHOLD;
    protected JMSServerEntryContext entryContext;
    protected Map connections;
    protected SynchronizedBoolean closed;
    protected boolean tryToConnect;
    protected boolean xaRecovery;
    protected static final JeusLogger logger;
    public static final long DEFAULT_THREAD_KEEP_TIME = 60000L;

    protected JMSServerEntry(JMSServerEntryContext entryContext) {
        super(entryContext.getRequestManager(), entryContext.getSerialExecutor());
        this.xaRecovery = entryContext.isXaRecovery();
        this.entryContext = entryContext;
        this.connections = Collections.synchronizedMap(new HashMap());
        this.closed = new SynchronizedBoolean(false);
    }

    protected void setId(long id) {
        this.id = id;
        this.name = "MQClient-E" + id;
    }

    public void start() {
    }

    public void recvData(MessageContainer packet) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2001_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2001_LEVEL, JeusMessage_JMS2._2001, packet);
        }
        this.handleArrivedMessage(packet);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void handleMessage(MessageContainer packet) {
        if (packet.isAdminMessage()) {
            this.handlAdminMessage((AdminMessage)packet);
        } else {
            this.handleMissingMessage(packet, null);
        }
    }

    public void handleException(MessageContainer packet, JMSException ex) {
        this.handleMissingMessage(packet, ex);
    }

    private void handlAdminMessage(AdminMessage message) {
        switch (message.getOperationID()) {
            case 19: {
                break;
            }
            case 113: {
                this.takeover(((TakeoverMessage)message).getActiveBrokerID());
            }
        }
    }

    protected abstract void takeover(short var1);

    public void handleRequestMessage(MessageContainer packet) {
        block3: {
            try {
                packet.setClientRouting(false);
                this.distributeMessage(packet);
            }
            catch (JMSException e) {
                this.handleMissingMessage(packet, e);
            }
            catch (Throwable t) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2002_LEVEL)) break block3;
                LogUtils.log(logger, JeusMessage_JMS2._2002_LEVEL, JeusMessage_JMS2._2002, packet, t);
            }
        }
    }

    private void distributeMessage(MessageContainer packet) throws JMSException {
        MessageHandler handler = this.findHandler(packet);
        try {
            handler.handleMessage(packet);
        }
        catch (JMSException ex) {
            handler.handleException(packet, ex);
        }
    }

    private MessageHandler findHandler(MessageContainer message) throws JMSException {
        switch (message.getLocalTargetID()) {
            case 3: {
                return this;
            }
            case 7: {
                return this.getConnection(message.getConnectionID());
            }
            case 23: {
                JeusConnection connection = this.getConnection(message.getConnectionID());
                return connection.getConnectionConsumerFacility(message.getConsumerID());
            }
            case 15: 
            case 31: 
            case 47: {
                JeusConnection connection = this.getConnection(message.getConnectionID());
                return connection.getSessionFacility(message.getSessionID());
            }
        }
        throw new JMSException("invalid message target for message : " + message);
    }

    private JeusConnection getConnection(int connectionID) throws JMSException {
        JeusConnection connection = (JeusConnection)this.connections.get(new Integer(connectionID));
        if (connection == null) {
            throw new JMSException("failed to find connection " + connectionID);
        }
        return connection;
    }

    public void handleMissingMessage(MessageContainer packet, JMSException ex) {
        block8: {
            if (packet.isAdminMessage()) {
                if (ex == null) {
                    if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2003_LEVEL)) {
                        LogUtils.log(logger, JeusMessage_JMS2._2003_LEVEL, JeusMessage_JMS2._2003, packet);
                    }
                } else if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2004_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS2._2004_LEVEL, JeusMessage_JMS2._2004, packet, (Throwable)ex);
                }
            } else {
                ClientMessage message = (ClientMessage)packet;
                try {
                    this.sendBackMessage(message);
                }
                catch (JMSException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2005_LEVEL)) break block8;
                    LogUtils.log(logger, JeusMessage_JMS2._2005_LEVEL, JeusMessage_JMS2._2005, message, (Throwable)e);
                }
            }
        }
    }

    public JMSBaseEntry getRoutingEntry(MessageContainer packet) throws JMSException {
        throw new JMSException("routing is not yet supported");
    }

    public void sendBackMessage(ClientMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2006_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2006_LEVEL, JeusMessage_JMS2._2006, message);
        }
        MessageHandleEvent event = MessageUtil.createEventMessage((byte)48, message);
        this.sendNotifyMessage(event);
    }

    public void registerConnection(int connectionID, JeusConnection connection) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2007_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2007_LEVEL, JeusMessage_JMS2._2007, new Object[]{connection, new Integer(connectionID)});
        }
        this.connections.put(new Integer(connectionID), connection);
    }

    public void unregisterConnection(int connectionID) {
        Object connection = this.connections.remove(new Integer(connectionID));
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2008_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2008_LEVEL, JeusMessage_JMS2._2008, new Object[]{connection, new Integer(connectionID)});
        }
    }

    public void shutdown() {
        this.prepareShutdown();
        this.executor.shutdown();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2009_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2009_LEVEL, JeusMessage_JMS2._2009, this);
        }
    }

    public void shutdownAll() {
        this.shutdownFacilities();
        this.shutdown();
    }

    public void shutdownEmpty() {
        if (this.connections.isEmpty()) {
            this.shutdown();
        }
    }

    public void shutdownFacilities() {
        JeusConnection[] shutdown = this.connections.values().toArray(new JeusConnection[this.connections.size()]);
        for (int i = 0; i < shutdown.length; ++i) {
            try {
                shutdown[i].closeFacility();
                continue;
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2010_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS2._2010_LEVEL, JeusMessage_JMS2._2010, e);
            }
        }
    }

    public boolean isNeedRouting(MessageContainer packet) {
        return false;
    }

    public void setSharedTransactionContext() throws JMSException {
        AdminMessage shared = MessageUtil.createAdminMessage((byte)3, (byte)111);
        this.sendAndWaitSyncRequest(shared, 0L);
    }

    protected final void sendCloseMessage() throws JMSException {
        AdminMessage close = MessageUtil.createAdminMessage((byte)3, (byte)6);
        JMSSyncRequest request = this.sendSyncRequest(close);
        MessageContainer packet = request.waitReply(SHUTDOWN_MESSAGE_TIMEOUT);
        if (packet == null && LogUtils.isLoggable(logger, JeusMessage_JMS2._2011_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2011_LEVEL, JeusMessage_JMS2._2011, new Long(SHUTDOWN_MESSAGE_TIMEOUT));
        }
    }

    public boolean isSameEntry(JMSServerEntry entry) {
        return this.brokerID == entry.brokerID && this.id == entry.id;
    }

    public Executor getPooledExecutor() {
        return this.executor.getPooledExecutor();
    }

    public String toString() {
        return this.name;
    }

    public boolean tryToConnect() {
        return this.tryToConnect;
    }

    public void cancelConnect() {
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    }
}

