/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.event;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import jeus.jms.client.event.EventActionListener;
import jeus.jms.client.event.EventSubscriber;
import jeus.jms.client.event.EventTopic;
import jeus.jms.client.facility.consumer.MessageConsumerFacility;

public class JeusEventSubscriber
implements EventSubscriber {
    private Session session;
    private MessageConsumerFacility consumer;
    private EventTopic eventTopic;
    private Topic topic;
    private EventActionListener actionListener;
    private String evaluator;
    private String durableName;
    private boolean isDurable;

    public JeusEventSubscriber(Session session, String evaluator, EventActionListener actionListener, EventTopic eventTopic) throws JMSException {
        this(session, evaluator, actionListener, eventTopic, false, null);
    }

    public JeusEventSubscriber(Session session, String evaluator, EventActionListener actionListener, EventTopic eventTopic, boolean isDurable, String durableName) throws JMSException {
        this.session = session;
        this.eventTopic = eventTopic;
        this.actionListener = actionListener;
        this.evaluator = evaluator;
        this.durableName = durableName;
        this.isDurable = isDurable;
        this.topic = eventTopic.getTopic();
        this.initialize();
    }

    private void initialize() throws JMSException {
        this.consumer = (MessageConsumerFacility)(this.isDurable ? this.session.createDurableSubscriber(this.topic, this.durableName) : this.session.createConsumer((Destination)this.topic, this.evaluator));
    }

    public EventTopic getEventTopic() {
        return this.eventTopic;
    }

    public void register() throws JMSException {
        this.consumer.setMessageListener(this.actionListener);
    }

    public void unregister() {
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void resume() throws JMSException {
        this.consumer.startFacility();
    }

    public void suspend() throws JMSException {
        this.consumer.stopFacility();
    }

    public void close() throws JMSException {
        if (this.isDurable) {
            this.session.unsubscribe(this.durableName);
        }
        this.consumer.close();
    }
}

