/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.event;

import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import jeus.jms.client.event.EventTopic;
import jeus.jms.client.facility.session.JeusSession;
import jeus.jms.common.message.admin.DeliveryCountMessage;
import jeus.jms.common.message.admin.DestinationCommandMessage;
import jeus.jms.common.message.admin.RequestConsumerCountMessage;

public class JeusEventTopic
implements EventTopic {
    private final Session session;
    private final Topic topic;

    public JeusEventTopic(Session session, Topic topic) {
        this.session = session;
        this.topic = topic;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void suspendSubscribers() throws JMSException {
        DestinationCommandMessage message = new DestinationCommandMessage(26, this.topic.getTopicName());
        message.setTargetID((byte)15);
        ((JeusSession)this.session).sendAndWaitReply(message);
    }

    public boolean checkActiveSubscriber() throws JMSException {
        RequestConsumerCountMessage countMessage = new RequestConsumerCountMessage(this.topic.getTopicName());
        countMessage = (RequestConsumerCountMessage)((JeusSession)this.session).sendAndWaitReply(countMessage);
        return countMessage.checkActiveConsumer();
    }

    public int getConsumerCount() throws JMSException {
        RequestConsumerCountMessage countMessage = new RequestConsumerCountMessage(this.topic.getTopicName());
        countMessage = (RequestConsumerCountMessage)((JeusSession)this.session).sendAndWaitReply(countMessage);
        return countMessage.getConsumerCount();
    }

    public long getDeliveryCount() throws JMSException {
        DeliveryCountMessage deliveryCountMessage = new DeliveryCountMessage(this.topic.getTopicName());
        deliveryCountMessage = (DeliveryCountMessage)((JeusSession)this.session).sendAndWaitReply(deliveryCountMessage);
        return deliveryCountMessage.getDeliveryCount();
    }
}

