/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.external;

import javax.jms.JMSException;
import javax.naming.Reference;
import javax.transaction.NotSupportedException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import jeus.jms.client.external.JEUSTransactionProvider;

public abstract class TransactionProvider {
    private static TransactionProvider provider;

    public static synchronized TransactionProvider getTransactionProvider() {
        if (provider == null) {
            provider = new JEUSTransactionProvider();
        }
        return provider;
    }

    public abstract XAResource getXAResource(XAResource var1);

    public abstract Transaction getTransaction();

    public abstract TransactionManager getTransactionManager();

    public abstract void registerXAConnectionFactory(Reference var1, String var2) throws JMSException;

    public abstract byte[] getPropagationContext();

    public static boolean isXATransacted() {
        return TransactionProvider.getTransactionProvider().getTransaction() != null;
    }

    public static Transaction getUnsharedTransaction() {
        return TransactionProvider.getTransactionProvider().getTransaction();
    }

    public static Transaction beginUnsharedTransaction() throws NotSupportedException {
        TransactionProvider provider = TransactionProvider.getTransactionProvider();
        TransactionManager manager = provider.getTransactionManager();
        if (manager == null) {
            throw new NotSupportedException();
        }
        try {
            manager.begin();
            return manager.getTransaction();
        }
        catch (Exception e) {
            try {
                manager.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NotSupportedException();
        }
    }
}

