/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jms.JMSException;
import jeus.jms.client.facility.connection.JeusConnection;
import jeus.jms.client.facility.consumer.LocalMessageConsumerFacility;
import jeus.jms.client.util.ClientSerialExecutable;
import jeus.jms.common.destination.TemporaryDestination;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MultipleMessageHandleEvent;
import jeus.jms.common.message.admin.SingleMessageHandleEvent;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.common.util.SerialExecutor;
import jeus.util.LinkedHashMap;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS2;

public abstract class TemporaryDestinationManager
implements MessageHandler {
    JeusConnection connection;
    TemporaryDestination destination;
    DistributionExecutable execution;
    private SerialExecutor executor;
    private Map transacted;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public TemporaryDestinationManager(TemporaryDestination dest) {
        this.destination = dest;
        this.initialize();
    }

    private void initialize() {
        this.connection = this.destination.getConnection();
        this.executor = this.connection.getClientExecutor();
        this.execution = new DistributionExecutable();
        this.transacted = new HashMap();
        this.execution.setSuspend(false);
    }

    public TemporaryDestination getDestination() {
        return this.destination;
    }

    public void produce(ClientMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2461_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2461_LEVEL, JeusMessage_JMS2._2461, message.getMessageID());
        }
        this.handleUserMessage(message);
    }

    public void handleMessage(MessageContainer packet) throws JMSException {
        if (packet.isAdminMessage()) {
            this.handleAdminMessage((AdminMessage)packet);
        } else {
            this.handleUserMessage((ClientMessage)packet);
        }
    }

    public void handleException(MessageContainer packet, JMSException e) {
        e.printStackTrace();
    }

    private void handleUserMessage(ClientMessage message) {
        if (message.isTransacted()) {
            int sessionID = message.getSessionID();
            this.addTransactedProducer(sessionID, message);
        } else {
            this.executor.execute(this.execution, message);
        }
    }

    private void addTransactedProducer(int sessionID, ClientMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2462_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2462_LEVEL, JeusMessage_JMS2._2462, new Object[]{new Integer(sessionID), message.getMessageID()});
        }
        List list = this.getTransactedQueue(sessionID);
        list.add(new TransactionalProducer(message));
    }

    private void addTransactedConsumer(int sessionID, MessageID messageID) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2463_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2463_LEVEL, JeusMessage_JMS2._2463, new Object[]{new Integer(sessionID), messageID});
        }
        List list = this.getTransactedQueue(sessionID);
        list.add(new TransactionalConsumer(messageID));
    }

    private synchronized List getTransactedQueue(int sessionID) {
        Integer key = new Integer(sessionID);
        LinkedList list = (LinkedList)this.transacted.get(key);
        if (list == null) {
            list = new LinkedList();
            this.transacted.put(key, list);
        }
        return list;
    }

    public void commitTransacted(int sessionID) {
        List list = this.getTransactedQueue(sessionID);
        for (TransactionalWork work : list) {
            work.commit();
        }
    }

    public void rollbackTransacted(int sessionID) {
        List list = this.getTransactedQueue(sessionID);
        for (TransactionalWork work : list) {
            work.rollback();
        }
    }

    private void handleAdminMessage(AdminMessage packet) {
        switch (packet.getOperationID()) {
            case 50: {
                this.acknowledge((SingleMessageHandleEvent)packet);
                return;
            }
            case 35: 
            case 49: {
                this.recover((SingleMessageHandleEvent)packet);
                return;
            }
            case 66: {
                this.acknowledge((MultipleMessageHandleEvent)packet);
                return;
            }
            case 64: 
            case 65: {
                this.recover((MultipleMessageHandleEvent)packet);
                return;
            }
            case 33: {
                return;
            }
        }
    }

    private void acknowledge(MultipleMessageHandleEvent message) {
        boolean transacted = message.isTransacted();
        ListIterator it = message.getMessageIterator();
        while (it.hasNext()) {
            MessageID messageID = (MessageID)it.next();
            if (transacted) {
                this.addTransactedConsumer(message.getSessionID(), messageID);
                continue;
            }
            this.acknowledge(messageID);
        }
    }

    private void acknowledge(SingleMessageHandleEvent message) {
        boolean transacted = message.isTransacted();
        MessageID messageID = message.getMessageID();
        if (transacted) {
            this.addTransactedConsumer(message.getSessionID(), messageID);
        } else {
            this.acknowledge(messageID);
        }
    }

    private void recover(MultipleMessageHandleEvent message) {
        ListIterator it = message.getInverseMessageIterator();
        while (it.hasPrevious()) {
            MessageID messageID = (MessageID)it.previous();
            this.recover(messageID);
        }
    }

    private void recover(SingleMessageHandleEvent message) {
        this.recover(message.getMessageID());
    }

    private void acknowledge(MessageID messageID) {
        this.execution.removeFromAckqueue(messageID);
    }

    private void recover(MessageID messageID) {
        ClientMessage message = this.execution.removeFromAckqueue(messageID);
        if (message != null) {
            this.execution.recover(message);
        }
    }

    public void shutdown() {
        this.execution.shutdown();
    }

    abstract boolean distribute(ClientMessage var1) throws JMSException;

    public abstract void addConsumer(LocalMessageConsumerFacility var1);

    public abstract void removeConsumer(LocalMessageConsumerFacility var1);

    public abstract boolean consumerAttatched();

    private class TransactionalConsumer
    implements TransactionalWork {
        private MessageID messageID;

        TransactionalConsumer(MessageID messageID) {
            this.messageID = messageID;
        }

        public void commit() {
            TemporaryDestinationManager.this.execution.removeFromAckqueue(this.messageID);
        }

        public void rollback() {
        }
    }

    private class TransactionalProducer
    implements TransactionalWork {
        private ClientMessage message;

        TransactionalProducer(ClientMessage message) {
            this.message = message;
        }

        public void commit() {
            TemporaryDestinationManager.this.execution.enqueueWork(this.message);
        }

        public void rollback() {
        }
    }

    private static interface TransactionalWork {
        public void commit();

        public void rollback();
    }

    class DistributionExecutable
    extends ClientSerialExecutable {
        private LinkedHashMap ackQueue = new LinkedHashMap();

        public boolean execute(ClientMessage message) throws JMSException {
            return TemporaryDestinationManager.this.distribute(message);
        }

        public void success(ClientMessage message) throws JMSException {
            this.ackQueue.put((Object)message.getMessageID(), (Object)message);
        }

        public ClientMessage removeFromAckqueue(MessageID messageID) {
            return (ClientMessage)this.ackQueue.remove((Object)messageID);
        }

        public void shutdown() {
            this.clearWorks();
            this.ackQueue.clear();
        }
    }
}

