/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.consumer;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.facility.connection.JeusConnection;
import jeus.jms.client.facility.consumer.JeusConnectionConsumer;
import jeus.jms.common.message.admin.CreateConsumerMessage;
import jeus.jms.common.message.admin.UnsubscribeMessage;

public class DurableConnectionConsumer
extends JeusConnectionConsumer {
    private String durableName;

    public DurableConnectionConsumer(JeusConnection connection, Topic topic, String durableName, String selector, ServerSessionPool sessionPool, int maxMessages) {
        super(connection, (Destination)topic, selector, sessionPool, maxMessages);
        this.durableName = durableName;
    }

    CreateConsumerMessage getCreateConsumerMessage(boolean recover) {
        CreateConsumerMessage message = super.getCreateConsumerMessage(recover);
        message.setOperationID((byte)12);
        message.setDurableName(this.durableName);
        return message;
    }

    void sendCloseMessage() throws JMSException {
        super.sendCloseMessage();
        if (JMSServerEntry.RI_COMPATIBLE) {
            UnsubscribeMessage message = new UnsubscribeMessage(this.durableName);
            message.setTargetID((byte)7);
            this.sendNotifyMessage(message);
        }
    }

    public String toString() {
        return super.toString() + "(" + this.durableName + ")";
    }
}

