/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.consumer;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.facility.Freezer;
import jeus.jms.client.facility.MessageEventProvider;
import jeus.jms.client.facility.consumer.ClientMessageQueue;
import jeus.jms.client.facility.consumer.MessageConsumerFacility;
import jeus.jms.client.facility.session.JeusSession;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CreateConsumerMessage;
import jeus.jms.common.message.admin.MessageHandleEvent;
import jeus.jms.common.util.AcknowledgeManager;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSSyncRequest;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Journal;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS2;

public class JeusMessageConsumer
extends ClientMessageQueue
implements MessageConsumerFacility {
    private SynchronizedBoolean closed;
    private int consumerID;
    private JeusSession session;
    private AcknowledgeManager ackManager;
    private DestinationIdentity destination;
    private List requets;
    private String consumerName;
    private String selector;
    private boolean noLocal;
    private MessageListener listener;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JeusMessageConsumer(Session session, Destination destination, String selector, boolean noLocal) {
        this.destination = (DestinationIdentity)destination;
        this.selector = this.trimSelector(selector);
        this.noLocal = noLocal;
        this.session = (JeusSession)session;
        this.initialize();
    }

    void initialize() {
        this.ackManager = new AcknowledgeManager(this.session.getSessionID(), this);
        this.closed = new SynchronizedBoolean(false);
        this.requets = Collections.synchronizedList(new LinkedList());
    }

    public void createFacility() throws JMSException {
        this.consumerID = this.acquireConsumerID();
        this.consumerName = this.session.getFacilityName() + this.getPartialIdentity() + this.consumerID;
        this.session.addedConsumer(this.consumerID, this);
        if (this.session.isStarted()) {
            this.startReceive();
        }
    }

    public AdminMessage sendAdminMessage(AdminMessage adminMessage) throws JMSException {
        this.checkPublic(adminMessage.getOperationID());
        adminMessage.setTargetID((byte)31);
        return this.sendAndWaitReply(adminMessage);
    }

    public AdminMessage sendAdminMessage(byte opcode) throws JMSException {
        this.checkPublic(opcode);
        return this.sendAndWaitReply(this.createAdminMessage(opcode));
    }

    private void checkPublic(byte opcode) throws JMSException {
        if (opcode >= 0) {
            throw new JMSException("'" + AdminMessage.getAdminMessageName(opcode) + "' is not a pblic admin message opcode.");
        }
    }

    private int acquireConsumerID() throws JMSException {
        CreateConsumerMessage message = this.getCreateConsumerMessage(false);
        AdminMessage reply = this.sendAndWaitReply(message);
        return reply.getConsumerID();
    }

    public void recoverFacility() throws JMSException {
        CreateConsumerMessage message = this.getCreateConsumerMessage(true);
        this.session.recover(message);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2191_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2191_LEVEL, JeusMessage_JMS2._2191, this);
        }
        this.setAsyncDelivery(this.listener != null);
        if (this.listener != null && LogUtils.isLoggable(logger, JeusMessage_JMS2._2192_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2192_LEVEL, JeusMessage_JMS2._2192, this);
        }
    }

    CreateConsumerMessage getCreateConsumerMessage(boolean recover) {
        CreateConsumerMessage message = new CreateConsumerMessage(this.destination.getLocalName());
        message.setTargetID(recover ? (byte)31 : 15);
        message.setBooleanFlag(this.session.isStarted());
        message.setConsumerID(this.consumerID);
        message.setSelector(this.selector);
        message.setNoLocal(this.noLocal);
        message.setRecovered(recover);
        return message;
    }

    public void handleMessage(MessageContainer packet) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2193_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2193_LEVEL, JeusMessage_JMS2._2193, new Object[]{packet, this});
        }
        if (packet.isAdminMessage()) {
            this.handleAdminMessage((AdminMessage)packet);
        } else {
            this.handleUserMessage((ClientMessage)packet);
        }
    }

    public void handleException(MessageContainer packet, JMSException ex) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2194_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2194_LEVEL, JeusMessage_JMS2._2194, packet, (Throwable)ex);
        }
    }

    private void handleAdminMessage(AdminMessage message) {
        message.getOperationID();
    }

    private void handleUserMessage(ClientMessage message) {
        this.prepareMessage(message);
        this.enqueueWork(message);
    }

    public void startFacility() throws JMSException {
        if (this.closed.get()) {
            return;
        }
        AdminMessage start = this.createAdminMessage((byte)4);
        this.sendNotifyMessage(start);
        this.startReceive();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2195_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2195_LEVEL, JeusMessage_JMS2._2195, this);
        }
    }

    private void startReceive() {
        this.setSuspend(false);
        if (this.isAsyncDelivery()) {
            this.startExecution();
        }
    }

    public void stopFacility() throws JMSException {
        if (this.closed.get()) {
            return;
        }
        this.setSuspend(true);
        if (this.isClosed()) {
            this.sendStopMessage();
        } else {
            this.sendSuspendMessage();
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        if (listener != null) {
            this.cancelRequests();
        }
        this.listener = listener;
        this.setAsyncDelivery(listener != null);
        if (!this.isEmpty()) {
            this.startExecution();
        }
    }

    public void onMessage(Message message) {
        this.listener.onMessage(message);
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    public Message receiveNoWait() throws JMSException {
        return this.receive(-1L);
    }

    public Message receive(long timeout) throws JMSException {
        this.checkClosed();
        if (this.isSuspended()) {
            return null;
        }
        ClientMessage message = this.acquireMessage(timeout);
        return this.afterReceive(message);
    }

    private Message afterReceive(ClientMessage message) throws JMSException {
        if (message == null) {
            return null;
        }
        this.prepareMessage(message);
        this.session.enlistGlobalTransaction();
        int ackmode = this.session.getAcknowledgeMode();
        message.consuming(ackmode);
        try {
            message.consumed(ackmode);
        }
        catch (JMSException e) {
            this.session.delistGlobalTransaction();
            throw e;
        }
        return message;
    }

    private void prepareMessage(ClientMessage message) {
        message.prepareMessage();
        message.setExecutionSession(this.session);
        message.setExecutionContext(this.ackManager);
    }

    public void recoverConsumed() throws JMSException {
        if (this.ackManager.isEmpty()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2196_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2196_LEVEL, JeusMessage_JMS2._2196, new Object[]{this, this.ackManager});
        }
        this.ackManager.recoverRemote();
    }

    public void acknowledgeConsumed(boolean transacted) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2197_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2197_LEVEL, JeusMessage_JMS2._2197, new Object[]{this, this.ackManager});
        }
        this.ackManager.acknowledge(transacted);
    }

    public void clearConsumed(boolean transacted) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2198_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2198_LEVEL, JeusMessage_JMS2._2198, new Object[]{this, this.ackManager});
        }
        this.ackManager.clearConsumed(transacted);
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.listener;
    }

    public void closeFacility() throws JMSException {
        this.close();
    }

    public void close() throws JMSException {
        if (!this.closed.commit(false, true)) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2199_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2199_LEVEL, JeusMessage_JMS2._2199, this);
        }
        this.stopFacility();
        this.shutdownExecutor();
        if (this.session.asyncAcknowledge() && !this.ackManager.isEmpty()) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2200_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2200_LEVEL, JeusMessage_JMS2._2200, this);
            }
            this.session.addFinishWork(new ShutdownWork());
        } else {
            this.shutdown();
        }
        this.cancelRequests();
    }

    void shutdown() throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2201_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2201_LEVEL, JeusMessage_JMS2._2201, this);
        }
        this.recoverConsumed();
        this.sendCloseMessage();
        this.session.removedConsumer(this.consumerID);
    }

    private void cancelRequests() {
        for (int i = 0; i < this.requets.size(); ++i) {
            JMSSyncRequest request = (JMSSyncRequest)this.requets.get(i);
            request.cancel();
        }
        this.requets.clear();
    }

    private void sendStopMessage() {
        AdminMessage stop = this.createAdminMessage((byte)5);
        this.sendAndWaitWhile(stop);
    }

    private void sendSuspendMessage() throws JMSException {
        AdminMessage stop = this.createAdminMessage((byte)34);
        this.sendNotifyMessage(stop);
    }

    private void sendCloseMessage() throws JMSException {
        AdminMessage close = this.createAdminMessage((byte)6);
        JMSSyncRequest request = this.sendSyncRequest(close);
        request.waitReply(JMSServerEntry.ADMIN_MESSAGE_TIMEOUT);
    }

    public MessageHandleEvent createMessageEvent(byte opcode, ClientMessage message) {
        MessageHandleEvent event = MessageUtil.createEventMessage(opcode, message);
        this.setFacilityTarget(event);
        return event;
    }

    public MessageHandleEvent createMessageEvent(byte opcode, List works) {
        MessageHandleEvent event = MessageUtil.createEventMessage(opcode, works);
        this.setFacilityTarget(event);
        return event;
    }

    public AdminMessage createAdminMessage(byte opcode) {
        AdminMessage admin = MessageUtil.createAdminMessage(opcode);
        this.setFacilityTarget(admin);
        return admin;
    }

    private void setFacilityTarget(AdminMessage event) {
        event.setTargetID((byte)31);
        event.setConsumerID(this.consumerID);
    }

    public void sendNotifyMessage(MessageContainer packet) throws JMSException {
        this.session.sendNotifyMessage(packet);
    }

    public void sendAndWaitWhile(MessageContainer packet) {
        this.session.sendAndWaitWhile(packet);
    }

    public AdminMessage sendAndWaitReply(MessageContainer packet) throws JMSException {
        return this.session.sendAndWaitReply(packet);
    }

    public AdminMessage sendAndWaitReply(MessageContainer packet, long time) throws JMSException {
        return this.session.sendAndWaitReply(packet, time);
    }

    public JMSSyncRequest sendSyncRequest(MessageContainer packet) throws JMSException {
        JMSSyncRequest request = this.session.sendSyncRequest(packet);
        this.requets.add(request);
        return request;
    }

    public void cancelSyncRequest(JMSSyncRequest request) {
        this.session.cancelSyncRequest(request);
        this.requets.remove(request);
    }

    private String trimSelector(String selector) {
        return selector != null && selector.trim().equals("") ? null : selector;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public boolean isClosed() {
        return this.session.isClosed() || this.closed.get();
    }

    public void checkClosed() throws JMSException {
        if (this.closed.get()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4271, 1);
        }
    }

    public String getFacilityName() {
        return this.consumerName;
    }

    public Journal getLogger() {
        return logger;
    }

    private boolean isAsyncDelivery() {
        return this.listener != null;
    }

    String getPartialIdentity() {
        return ".MC";
    }

    public String toString() {
        return this.consumerName;
    }

    public void preExecution(ClientMessage message) throws JMSException {
        message.setMessageListener(this.listener);
    }

    public boolean execute(ClientMessage message) {
        this.session.enqueueAsyncMessages((byte)31, message);
        return true;
    }

    public void exception(ClientMessage message, JMSException e) {
        this.recover((MessageEventProvider)this, message);
    }

    public void workCompleted() {
        this.session.run();
    }

    public void freeze(Freezer freezer) {
    }

    public void thaw(Freezer freezer) {
    }

    protected void messageAvailable() {
        if (this.isAsyncDelivery() || this.isClosed()) {
            this.startExecution();
        }
        this.works.notify();
    }

    private class ShutdownWork
    implements Runnable {
        private ShutdownWork() {
        }

        public void run() {
            block2: {
                try {
                    JeusMessageConsumer.this.shutdown();
                }
                catch (JMSException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2202_LEVEL)) break block2;
                    LogUtils.log(logger, JeusMessage_JMS2._2202_LEVEL, JeusMessage_JMS2._2202, JeusMessageConsumer.this, (Throwable)e);
                }
            }
        }

        public String toString() {
            return "SHUTDOWN " + JeusMessageConsumer.this;
        }
    }
}

