/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.producer;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import jeus.jms.client.facility.ClientFacility;
import jeus.jms.client.facility.Freezer;
import jeus.jms.client.facility.producer.AbstractProducer;
import jeus.jms.client.facility.session.JeusSession;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageConversion;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CreateProducerMessage;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSSyncRequest;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent.SynchronizedRef;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS2;

public class JeusMessageProducer
extends AbstractProducer
implements ClientFacility {
    private JeusSession session;
    private String producerName;
    private int producerID;
    private DestinationIdentity destination;
    private SynchronizedRef iceRef;
    private SynchronizedBoolean closed;
    private SynchronizedBoolean prepared;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JeusMessageProducer(Session session, DestinationIdentity destination, int producerID) {
        this.session = (JeusSession)session;
        this.destination = destination;
        this.producerID = producerID;
    }

    public void createFacility() throws JMSException {
        CreateProducerMessage message = this.getCreateProducerMessage(false);
        this.sendAndWaitReply(message);
        this.producerName = this.session.getFacilityName() + this.getProperty() + this.producerID + (this.destination == null ? "" : "(" + this.destination + ")");
        this.session.addedProducer(this.producerID, this);
        this.iceRef = new SynchronizedRef(null);
        this.closed = new SynchronizedBoolean(false);
        this.prepared = new SynchronizedBoolean(false);
    }

    public AdminMessage sendAdminMessage(AdminMessage adminMessage) throws JMSException {
        this.checkPublic(adminMessage.getOperationID());
        adminMessage.setTargetID((byte)47);
        return this.sendAndWaitReply(adminMessage);
    }

    public AdminMessage sendAdminMessage(byte opcode) throws JMSException {
        this.checkPublic(opcode);
        return this.sendAndWaitReply(this.createAdminMessage(opcode));
    }

    private void checkPublic(byte opcode) throws JMSException {
        if (opcode >= 0) {
            throw new JMSException("'" + AdminMessage.getAdminMessageName(opcode) + "' is not a pblic admin message opcode.");
        }
    }

    public void recoverFacility() throws JMSException {
        CreateProducerMessage message = this.getCreateProducerMessage(true);
        this.session.recover(message);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2491_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2491_LEVEL, JeusMessage_JMS2._2491, this);
        }
    }

    private CreateProducerMessage getCreateProducerMessage(boolean recover) {
        CreateProducerMessage message = new CreateProducerMessage(this.destination);
        message.setTargetID(recover ? (byte)47 : 15);
        message.setAssignedProducerID(this.producerID);
        message.setRecovered(recover);
        return message;
    }

    public void handleMessage(MessageContainer packet) {
    }

    public void handleException(MessageContainer packet, JMSException ex) {
    }

    public void startFacility() throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2492_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2492_LEVEL, JeusMessage_JMS2._2492, this);
        }
    }

    public void stopFacility() throws JMSException {
        if (this.prepared.commit(false, true)) {
            this.sendStopMessage();
        }
    }

    public void freeze(Freezer freezer) {
        this.iceRef.set(new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void thaw(Freezer freezer) {
        Object ice = this.iceRef.get();
        if (ice != null) {
            Object object = ice;
            synchronized (object) {
                ice.notify();
            }
        }
        this.iceRef.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIce() throws JMSException {
        if (this.iceRef.get() != null) {
            Object ice;
            Object object = ice = this.iceRef.get();
            synchronized (object) {
                try {
                    ice.wait();
                }
                catch (InterruptedException e) {
                    throw new JMSException(e.getMessage());
                }
            }
        }
    }

    public void closeFacility() throws JMSException {
        this.close();
    }

    public String getFacilityName() {
        return this.producerName;
    }

    public boolean isClosed() {
        return this.session.isClosed() || this.closed.get();
    }

    public void send(Message message) throws JMSException {
        message.setJMSDestination((Destination)this.destination);
        this.sendMessage(this.destination, message, this.timeToLive, this.priority, this.deliveryMode);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        message.setJMSDestination((Destination)this.destination);
        this.sendMessage(this.destination, message, timeToLive, priority, deliveryMode);
    }

    public void send(Destination destination, Message message) throws JMSException {
        Destination dest = this.checkDuplicatedDestination(destination);
        this.sendMessage(dest, message, this.timeToLive, this.priority, this.deliveryMode);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Destination dest = this.checkDuplicatedDestination(destination);
        this.sendMessage(dest, message, timeToLive, priority, deliveryMode);
    }

    private void sendMessage(Destination destination, Message message, long timeToLive, int priority, int deliveryMode) throws JMSException {
        this.checkIce();
        this.checkClosed();
        this.checkDestination(destination);
        message.setJMSTimestamp(System.currentTimeMillis());
        message.setJMSDestination(destination);
        message.setJMSExpiration(timeToLive);
        message.setJMSPriority(priority);
        message.setJMSDeliveryMode(deliveryMode);
        ClientMessage msg = this.getClientMessage(message);
        msg.checkAutoCompaction();
        msg.checkScheduledTime();
        this.setFacilityTarget(msg);
        this.session.producedMessage(msg);
        try {
            message.setJMSMessageID(msg.getJMSMessageID());
            message.setJMSDeliveryMode(msg.isPersistent() ? 2 : 1);
        }
        catch (JMSException e) {
            // empty catch block
        }
    }

    private ClientMessage getClientMessage(Message message) throws JMSException {
        if (message instanceof ClientMessage) {
            return (ClientMessage)message;
        }
        return MessageConversion.transformMessage(message);
    }

    public void sendNotifyMessage(MessageContainer packet) throws JMSException {
        this.session.sendNotifyMessage(packet);
    }

    public void sendAndWaitWhile(MessageContainer packet) {
        this.session.sendAndWaitWhile(packet);
    }

    public AdminMessage sendAndWaitReply(MessageContainer packet) throws JMSException {
        return this.session.sendAndWaitReply(packet);
    }

    public AdminMessage sendAndWaitReply(MessageContainer packet, long timeout) throws JMSException {
        return this.session.sendAndWaitReply(packet, timeout);
    }

    public JMSSyncRequest sendSyncRequest(MessageContainer packet) throws JMSException {
        return this.session.sendSyncRequest(packet);
    }

    public void cancelSyncRequest(JMSSyncRequest request) {
        this.session.cancelSyncRequest(request);
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    public void close() throws JMSException {
        if (this.closed.get()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2493_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2493_LEVEL, JeusMessage_JMS2._2493, this);
        }
        this.stopFacility();
        if (this.session.asyncAcknowledge()) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2494_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2494_LEVEL, JeusMessage_JMS2._2494, this);
            }
            this.session.addFinishWork(new ShutdownWork());
        } else {
            this.shutdown();
        }
    }

    private void shutdown() throws JMSException {
        if (this.closed.get()) {
            return;
        }
        this.sendCloseMessage();
        this.session.removedProducer(this.producerID);
        this.closed.commit(false, true);
    }

    private void sendStopMessage() throws JMSException {
        AdminMessage stop = this.createAdminMessage((byte)5);
        stop.setBooleanFlag(this.isClosed());
        if (this.isClosed()) {
            this.sendAndWaitWhile(stop);
        } else {
            this.sendNotifyMessage(stop);
        }
    }

    private void sendCloseMessage() throws JMSException {
        AdminMessage close = this.createAdminMessage((byte)6);
        this.sendNotifyMessage(close);
    }

    public AdminMessage createAdminMessage(byte opcode) {
        AdminMessage admin = MessageUtil.createAdminMessage(opcode);
        this.setFacilityTarget(admin);
        return admin;
    }

    private void setFacilityTarget(MessageContainer admin) {
        admin.setTargetID((byte)47);
        admin.setProducerID(this.producerID);
    }

    private Destination checkDuplicatedDestination(Destination destination) {
        if (destination != null && this.destination != null) {
            throw new UnsupportedOperationException("message producer is already bound to destination " + this.destination);
        }
        return destination != null ? destination : this.destination;
    }

    private void checkDestination(Destination destination) throws JMSException {
        if (destination == null) {
            throw new UnsupportedOperationException("destination is not set");
        }
        if (!(destination instanceof DestinationIdentity)) {
            throw new InvalidDestinationException("invalid destination of type " + destination.getClass());
        }
    }

    void checkClosed() throws JMSException {
        if (this.closed.get()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4271, 1);
        }
    }

    String getProperty() {
        return ".P";
    }

    public String toString() {
        return this.producerName;
    }

    private class ShutdownWork
    implements Runnable {
        private ShutdownWork() {
        }

        public void run() {
            block2: {
                try {
                    JeusMessageProducer.this.shutdown();
                }
                catch (JMSException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2495_LEVEL)) break block2;
                    LogUtils.log(logger, JeusMessage_JMS2._2495_LEVEL, JeusMessage_JMS2._2495, JeusMessageProducer.this, (Throwable)e);
                }
            }
        }

        public String toString() {
            return "SHUTDOWN " + JeusMessageProducer.this;
        }
    }
}

