/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.session;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import jeus.jms.FileMessage;
import jeus.jms.JeusQueueSession;
import jeus.jms.JeusTopicSession;
import jeus.jms.client.facility.ClientFacility;
import jeus.jms.client.facility.Freezer;
import jeus.jms.client.facility.TemporaryDestinationManager;
import jeus.jms.client.facility.browser.JeusQueueBrowser;
import jeus.jms.client.facility.connection.ConnectionFacility;
import jeus.jms.client.facility.connection.JeusConnection;
import jeus.jms.client.facility.consumer.DurableTopicSubscriber;
import jeus.jms.client.facility.consumer.JeusLocalMessageConsumer;
import jeus.jms.client.facility.consumer.JeusLocalQueueReceiver;
import jeus.jms.client.facility.consumer.JeusLocalTopicSubscriber;
import jeus.jms.client.facility.consumer.JeusMessageConsumer;
import jeus.jms.client.facility.consumer.JeusQueueReceiver;
import jeus.jms.client.facility.consumer.JeusTopicSubscriber;
import jeus.jms.client.facility.consumer.MessageConsumerFacility;
import jeus.jms.client.facility.producer.JeusMessageProducer;
import jeus.jms.client.facility.producer.JeusQueueSender;
import jeus.jms.client.facility.producer.JeusTopicPublisher;
import jeus.jms.client.facility.session.SessionFacility;
import jeus.jms.client.util.DestinationCreationArgument;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.destination.JeusQueue;
import jeus.jms.common.destination.JeusTemporaryQueue;
import jeus.jms.common.destination.JeusTemporaryTopic;
import jeus.jms.common.destination.JeusTopic;
import jeus.jms.common.message.BytesMessageImpl;
import jeus.jms.common.message.EmptyMessage;
import jeus.jms.common.message.FileMessageImpl;
import jeus.jms.common.message.MapMessageImpl;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.ObjectMessageImpl;
import jeus.jms.common.message.StreamMessageImpl;
import jeus.jms.common.message.TextMessageImpl;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.BrowseQueueMessage;
import jeus.jms.common.message.admin.CreateDestinationMessage;
import jeus.jms.common.message.admin.UnsubscribeMessage;
import jeus.jms.common.util.BoundedInteger;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.WorkQueue;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS2;

public abstract class AbstractSession
implements SessionFacility,
JeusQueueSession,
JeusTopicSession {
    protected final int type;
    protected final int ackMode;
    protected final JeusConnection connection;
    protected int sessionID = -1;
    protected String sessionName;
    private WorkQueue finishWorks;
    private BoundedInteger producerSeq;
    private BoundedInteger consumerSeq;
    protected Map consumerList;
    protected Map producerList;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public AbstractSession(Connection connection, int ackMode, int type) {
        this.connection = (JeusConnection)connection;
        this.ackMode = ackMode;
        this.type = type;
    }

    public ConnectionFacility getConnection() {
        return this.connection;
    }

    void initialize() {
        this.finishWorks = new WorkQueue();
        this.consumerList = Collections.synchronizedMap(new Hashtable(3));
        this.producerList = Collections.synchronizedMap(new Hashtable(3));
        this.producerSeq = BoundedInteger.getIncrementor();
        this.consumerSeq = BoundedInteger.getDecrementor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() throws JMSException {
        if (this.isClosed()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2391_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2391_LEVEL, JeusMessage_JMS2._2391, this);
        }
        if (this.ackMode == 2) {
            this.doFinishWorks();
        }
        if (this.isXAParticipant()) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2392_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2392_LEVEL, JeusMessage_JMS2._2392, new Object[]{this, (this.isTransacted() ? "xa transacted " : "") + this.consumerList, this.producerList});
            }
            this.addFinishWorkAtLast(new ShutdownWork());
            return;
        }
        if (this.isLocalTransacted()) {
            this.flushTransaction();
        }
        this.prepareClose();
        try {
            this.sendCloseMessage();
        }
        finally {
            this.connection.unregisterSession(this.sessionID);
        }
    }

    public boolean hasPendingWorks() {
        return !this.consumerList.isEmpty() || !this.producerList.isEmpty();
    }

    public boolean asyncAcknowledge() {
        return this.isTransactionParticipant() || this.ackMode == 2;
    }

    public AdminMessage sendAdminMessage(AdminMessage adminMessage) throws JMSException {
        adminMessage.setTargetID((byte)15);
        return this.sendAndWaitReply(adminMessage);
    }

    public AdminMessage sendAdminMessage(byte opcode) throws JMSException {
        AdminMessage adminMessage = this.createAdminMessage(opcode);
        return this.sendAndWaitReply(adminMessage);
    }

    public void sendNotification(AdminMessage adminMessage) throws JMSException {
    }

    public void sendNotification(byte opcode) throws JMSException {
    }

    private void sendCloseMessage() throws JMSException {
        AdminMessage close = this.createAdminMessage((byte)6);
        this.sendNotifyMessage(close);
    }

    void recoverAttendents() {
        ClientFacility[] producers = this.producerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < producers.length; ++i) {
            try {
                producers[i].recoverFacility();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        ClientFacility[] consumers = this.consumerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < consumers.length; ++i) {
            try {
                consumers[i].recoverFacility();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    void startAttendents() {
        ClientFacility[] producers = this.producerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < producers.length; ++i) {
            try {
                producers[i].startFacility();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        ClientFacility[] consumers = this.consumerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < consumers.length; ++i) {
            try {
                consumers[i].startFacility();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    void stopAttendents() {
        ClientFacility[] producers = this.producerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < producers.length; ++i) {
            try {
                producers[i].stopFacility();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        ClientFacility[] consumers = this.consumerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < consumers.length; ++i) {
            try {
                consumers[i].stopFacility();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    void closeAttendents() {
        ClientFacility[] producers = this.producerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < producers.length; ++i) {
            try {
                producers[i].closeFacility();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        ClientFacility[] consumers = this.consumerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < consumers.length; ++i) {
            try {
                consumers[i].closeFacility();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return new BytesMessageImpl();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        return new EmptyMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        return new ObjectMessageImpl(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return new StreamMessageImpl();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        return new TextMessageImpl(text);
    }

    public FileMessage createFileMessage() throws JMSException {
        this.checkClosed();
        return new FileMessageImpl();
    }

    public FileMessage createFileMessage(URL url) throws JMSException {
        this.checkClosed();
        return new FileMessageImpl(url);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2393_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2393_LEVEL, JeusMessage_JMS2._2393, new Object[]{destination, this});
        }
        this.checkClosed();
        DestinationIdentity dest = this.checkProducerDestination(destination);
        int producerID = this.producerSeq.getNextValue();
        JeusMessageProducer producer = new JeusMessageProducer(this, dest, producerID);
        producer.createFacility();
        return producer;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2394_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2394_LEVEL, JeusMessage_JMS2._2394, new Object[]{queue, this});
        }
        this.checkClosed();
        this.confirmQueue();
        DestinationIdentity dest = this.checkProducerDestination((Destination)queue);
        int producerID = this.producerSeq.getNextValue();
        JeusQueueSender producer = new JeusQueueSender(this, dest, producerID);
        producer.createFacility();
        return producer;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2395_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2395_LEVEL, JeusMessage_JMS2._2395, new Object[]{topic, this});
        }
        this.checkClosed();
        this.confirmTopic();
        DestinationIdentity dest = this.checkProducerDestination((Destination)topic);
        int producerID = this.producerSeq.getNextValue();
        JeusTopicPublisher producer = new JeusTopicPublisher(this, dest, producerID);
        producer.createFacility();
        return producer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.createConsumer(destination, selector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        DestinationIdentity dest = this.checkConsumerDestination(destination);
        if (dest.isTemporary()) {
            return this.createLocalConsumer(dest, selector, noLocal);
        }
        return this.createRemoteConsumer(dest, selector, noLocal);
    }

    private MessageConsumerFacility createLocalConsumer(DestinationIdentity dest, String selector, boolean noLocal) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2396_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2396_LEVEL, JeusMessage_JMS2._2396, new Object[]{dest, this});
        }
        TemporaryDestinationManager manager = this.connection.getTemporaryDestinationManager(dest);
        JeusLocalMessageConsumer consumer = new JeusLocalMessageConsumer(this, manager, selector, noLocal);
        consumer.createFacility();
        manager.addConsumer(consumer);
        return consumer;
    }

    private MessageConsumerFacility createRemoteConsumer(DestinationIdentity dest, String selector, boolean noLocal) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2397_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2397_LEVEL, JeusMessage_JMS2._2397, new Object[]{dest, this});
        }
        JeusMessageConsumer consumer = new JeusMessageConsumer(this, dest, selector, noLocal);
        consumer.createFacility();
        return consumer;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        this.checkClosed();
        this.confirmQueue();
        DestinationIdentity dest = this.checkConsumerDestination((Destination)queue);
        if (dest.isTemporary()) {
            return this.createLocalConsumer((JeusTemporaryQueue)dest, selector);
        }
        return this.createRemoteConsumer((Queue)dest, selector);
    }

    private QueueReceiver createLocalConsumer(JeusTemporaryQueue dest, String selector) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2398_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2398_LEVEL, JeusMessage_JMS2._2398, new Object[]{dest, this});
        }
        TemporaryDestinationManager manager = this.connection.getTemporaryDestinationManager(dest);
        JeusLocalQueueReceiver consumer = new JeusLocalQueueReceiver(this, manager, selector);
        consumer.createFacility();
        manager.addConsumer(consumer);
        return consumer;
    }

    private QueueReceiver createRemoteConsumer(Queue dest, String selector) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2399_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2399_LEVEL, JeusMessage_JMS2._2399, new Object[]{dest, this});
        }
        JeusQueueReceiver consumer = new JeusQueueReceiver(this, dest, selector);
        consumer.createFacility();
        return consumer;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        this.confirmTopic();
        DestinationIdentity dest = this.checkConsumerDestination((Destination)topic);
        if (dest.isTemporary()) {
            return this.createLocalConsumer((JeusTemporaryTopic)dest, selector, noLocal);
        }
        return this.createRemoteConsumer((Topic)dest, selector, noLocal);
    }

    private TopicSubscriber createLocalConsumer(JeusTemporaryTopic dest, String selector, boolean noLocal) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2400_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2400_LEVEL, JeusMessage_JMS2._2400, new Object[]{dest, this});
        }
        TemporaryDestinationManager manager = this.connection.getTemporaryDestinationManager(dest);
        JeusLocalTopicSubscriber consumer = new JeusLocalTopicSubscriber(this, manager, selector, noLocal);
        consumer.createFacility();
        manager.addConsumer(consumer);
        return consumer;
    }

    private TopicSubscriber createRemoteConsumer(Topic dest, String selector, boolean noLocal) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2401_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2401_LEVEL, JeusMessage_JMS2._2401, new Object[]{dest, this});
        }
        JeusTopicSubscriber consumer = new JeusTopicSubscriber((Session)this, dest, selector, noLocal);
        consumer.createFacility();
        return consumer;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2402_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2402_LEVEL, JeusMessage_JMS2._2402, new Object[]{topic, this, name});
        }
        this.checkClosed();
        this.confirmTopic();
        DestinationIdentity dest = this.checkConsumerDestination((Destination)topic);
        if (dest.isTemporary()) {
            throw new JMSException("durable subscriber for temporary topic is not allowed");
        }
        this.checkClientID();
        DurableTopicSubscriber subscriber = new DurableTopicSubscriber(this, (Topic)dest, name, selector, noLocal);
        subscriber.createFacility();
        return subscriber;
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkClosed();
        this.confirmQueue();
        Destination dest = this.findDestination(true, queueName);
        return (Queue)dest;
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.checkClosed();
        this.confirmTopic();
        Destination dest = this.findDestination(false, topicName);
        return (Topic)dest;
    }

    private Destination findDestination(boolean queue, String destName) throws JMSException {
        this.checkClosed();
        DestinationCreationArgument argument = new DestinationCreationArgument(queue, destName);
        if (argument.isCreationCommand()) {
            CreateDestinationMessage msg = new CreateDestinationMessage(argument.getBrokerName(), argument.getDestinationName(), argument.getExportName(), argument.getMultipleReceiver());
            msg.setTargetID((byte)3);
            msg.setDestinationType(queue);
            this.sendAndWaitReply(msg);
        }
        return this.createDestinationReference(queue, argument.getBrokerName(), argument.getDestinationName());
    }

    private Destination createDestinationReference(boolean queue, String brokerName, String destName) {
        if (queue) {
            return new JeusQueue(brokerName, destName);
        }
        return new JeusTopic(brokerName, destName);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        this.checkClosed();
        this.confirmQueue();
        this.checkConsumerDestination((Destination)queue);
        BrowseQueueMessage message = new BrowseQueueMessage((JeusQueue)queue, selector);
        message = (BrowseQueueMessage)this.sendAndWaitReply(message);
        return new JeusQueueBrowser(queue, selector, message.getMessages());
    }

    public int getAcknowledgeMode() {
        return this.isXAParticipant() ? 0 : this.ackMode;
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.isTransacted();
    }

    public boolean isTransacted() {
        return this.isXAEnlisted() || this.isLocalTransacted();
    }

    public boolean isTransactionParticipant() {
        return this.isXAParticipant() || this.isLocalTransacted();
    }

    public boolean isXAEnlisted() {
        return false;
    }

    public boolean isXAParticipant() {
        return false;
    }

    public boolean isLocalTransacted() {
        return this.ackMode == 0;
    }

    public String getFacilityName() {
        return this.sessionName;
    }

    public void doFinishWorks() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2403_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2403_LEVEL, JeusMessage_JMS2._2403, new Object[]{this, this.finishWorks});
        }
        if (!this.finishWorks.isEmpty()) {
            this.finishWorks.run();
        }
    }

    public void addFinishWork(Runnable work) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2404_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2404_LEVEL, JeusMessage_JMS2._2404, new Object[]{work, this});
        }
        this.finishWorks.enqueueLast(work);
    }

    public void addFinishWorkAtLast(Runnable work) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2405_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2405_LEVEL, JeusMessage_JMS2._2405, new Object[]{work, this});
        }
        this.finishWorks.enqueueFirst(work);
    }

    public void addedProducer(int producerID, MessageProducer producer) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2406_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2406_LEVEL, JeusMessage_JMS2._2406, new Object[]{new Integer(producerID), this});
        }
        this.producerList.put(new Integer(producerID), producer);
    }

    public void removedProducer(int producerID) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2407_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2407_LEVEL, JeusMessage_JMS2._2407, new Object[]{new Integer(producerID), this});
        }
        this.producerList.remove(new Integer(producerID));
    }

    public void addedConsumer(int consumerID, MessageConsumer consumer) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2408_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2408_LEVEL, JeusMessage_JMS2._2408, new Object[]{new Integer(consumerID), this});
        }
        this.consumerList.put(new Integer(consumerID), consumer);
    }

    public void removedConsumer(int consumerID) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2409_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2409_LEVEL, JeusMessage_JMS2._2409, new Object[]{new Integer(consumerID), this});
        }
        this.consumerList.remove(new Integer(consumerID));
    }

    public ClientFacility findConsumer(int consumerID) {
        return (ClientFacility)this.consumerList.get(new Integer(consumerID));
    }

    private DestinationIdentity checkConsumerDestination(Destination destination) throws JMSException {
        if (!(destination instanceof DestinationIdentity)) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3127, 3);
        }
        DestinationIdentity dest = (DestinationIdentity)destination;
        if (dest.isTemporary() && this.connection.getEntryID() != dest.getEntryID() && this.connection.getEntryID() != (long)dest.getTemporaryConnectionID()) {
            throw new InvalidDestinationException("temporary destination " + destination + " is not belong to current connection");
        }
        return dest;
    }

    private DestinationIdentity checkProducerDestination(Destination destination) throws JMSException {
        if (destination != null && !(destination instanceof DestinationIdentity)) {
            throw new JMSException("invalid destnation:" + destination);
        }
        return (DestinationIdentity)destination;
    }

    private void checkClientID() throws JMSException {
        String clientID = this.connection.getClientID();
        if (clientID == null) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4292);
        }
    }

    private void confirmQueue() throws IllegalStateException {
        if (this.type == 84) {
            throw new IllegalStateException("This session is not for Queue");
        }
    }

    private void confirmTopic() throws IllegalStateException {
        if (this.type == 81) {
            throw new IllegalStateException("This session is not for Topic");
        }
    }

    void checkClosed() throws JMSException {
        if (this.isClosed()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4271, 1);
        }
    }

    public boolean isStarted() {
        return this.connection.isStarted();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        this.confirmQueue();
        return this.connection.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        this.confirmTopic();
        return this.connection.createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkClosed();
        this.confirmTopic();
        this.checkClientID();
        UnsubscribeMessage message = new UnsubscribeMessage(name);
        message.setTargetID((byte)15);
        this.sendAndWaitReply(message);
    }

    void acknowledgeConsumers() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2410_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2410_LEVEL, JeusMessage_JMS2._2410, this);
        }
        boolean transacted = this.isTransacted();
        MessageConsumerFacility[] consumerArray = this.consumerList.values().toArray(new MessageConsumerFacility[0]);
        for (int i = 0; i < consumerArray.length; ++i) {
            try {
                consumerArray[i].acknowledgeConsumed(transacted);
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    void recoverConsumers() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2411_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2411_LEVEL, JeusMessage_JMS2._2411, this);
        }
        MessageConsumerFacility[] consumerArray = this.consumerList.values().toArray(new MessageConsumerFacility[0]);
        for (int i = 0; i < consumerArray.length; ++i) {
            try {
                consumerArray[i].recoverConsumed();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    void clearConsumers() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2412_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2412_LEVEL, JeusMessage_JMS2._2412, this);
        }
        MessageConsumerFacility[] consumerArray = this.consumerList.values().toArray(new MessageConsumerFacility[0]);
        for (int i = 0; i < consumerArray.length; ++i) {
            consumerArray[i].clearConsumed(false);
        }
    }

    AdminMessage createAdminMessage(byte opcode) {
        AdminMessage admin = MessageUtil.createAdminMessage(opcode);
        admin.setTargetID((byte)15);
        return admin;
    }

    public int getTemporaryConsumerID() {
        return this.consumerSeq.getNextValue();
    }

    void prepareClose() {
    }

    public void thaw(Freezer freezer) {
        ClientFacility[] consumers = this.consumerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < consumers.length; ++i) {
            ClientFacility consumer = consumers[i];
            consumer.thaw(freezer);
        }
        ClientFacility[] producers = this.producerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < producers.length; ++i) {
            ClientFacility producer = producers[i];
            producer.thaw(freezer);
        }
    }

    public void freeze(Freezer freezer) {
        ClientFacility[] consumers = this.consumerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < consumers.length; ++i) {
            ClientFacility consumer = consumers[i];
            consumer.freeze(freezer);
        }
        ClientFacility[] producers = this.producerList.values().toArray(new ClientFacility[0]);
        for (int i = 0; i < producers.length; ++i) {
            ClientFacility producer = producers[i];
            producer.freeze(freezer);
        }
    }

    private class ShutdownWork
    implements Runnable {
        private ShutdownWork() {
        }

        public void run() {
            block2: {
                try {
                    AbstractSession.this.shutdown();
                    AbstractSession.this.connection.shutdown();
                }
                catch (JMSException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2413_LEVEL)) break block2;
                    LogUtils.log(logger, JeusMessage_JMS2._2413_LEVEL, JeusMessage_JMS2._2413, AbstractSession.this, (Throwable)e);
                }
            }
        }

        public String toString() {
            return "SHUTDOWN " + AbstractSession.this;
        }
    }
}

