/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.util;

import java.util.Collection;
import java.util.LinkedList;
import javax.jms.JMSException;
import jeus.jms.client.facility.MessageEventProvider;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.util.ISerialExecutable;

public abstract class ClientSerialExecutable
implements ISerialExecutable {
    private Thread executor;
    private boolean suspend;
    private boolean executing;
    private ClientMessage initialWork;
    protected final LinkedList works;

    public ClientSerialExecutable() {
        this.works = new LinkedList();
        this.suspend = true;
    }

    public Thread executor() {
        return this.isExecuting() ? this.executor : null;
    }

    public ClientSerialExecutable(LinkedList works) {
        this.works = works;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getWorks() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.getAll();
        }
    }

    private LinkedList getAll() {
        if (this.initialWork != null) {
            this.works.addFirst(this.initialWork);
            this.initialWork = null;
        }
        return this.works;
    }

    private void enqueueFirst(ClientMessage message) {
        if (this.initialWork == null) {
            this.initialWork = message;
        } else {
            this.works.addFirst(message);
        }
    }

    private void enqueueFirst(Collection messages) {
        if (this.initialWork != null) {
            this.works.addFirst(this.initialWork);
            this.initialWork = null;
        }
        this.works.addAll(0, messages);
    }

    private void enqueueLast(ClientMessage message) {
        if (this.checkEmpty()) {
            this.initialWork = message;
        } else {
            this.works.addLast(message);
        }
    }

    private ClientMessage dequeueFirst() {
        if (this.initialWork != null) {
            ClientMessage message = this.initialWork;
            this.initialWork = null;
            return message;
        }
        if (!this.works.isEmpty()) {
            return (ClientMessage)this.works.removeFirst();
        }
        return null;
    }

    private boolean checkEmpty() {
        return this.initialWork == null && this.works.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.works.size() + (this.initialWork == null ? 0 : 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.initialWork == null && this.works.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWorks() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.initialWork = null;
            this.works.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspend(boolean suspend) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.suspend = suspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWork(ClientMessage message) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.enqueueLast(message);
            this.messageAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientMessage dequeueWork() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.dequeueFirst();
        }
    }

    protected void messageAvailable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkExecutor() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return !this.suspend && !this.checkEmpty() && this.checkExecution(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExecuting() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.executing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecuting(boolean execute) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.executing = execute;
        }
    }

    private boolean checkExecution(boolean assume, boolean newValue) {
        if (this.executing != assume) {
            return false;
        }
        this.executing = newValue;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.suspend;
        }
    }

    public void startExecution(ClientMessage message) {
        this.enqueueWork(message);
        this.startExecution();
    }

    public void startExecution() {
        if (this.checkExecutor()) {
            this.run();
        }
    }

    public void recover(ClientMessage message) {
        this.recover(null, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(MessageEventProvider provider, ClientMessage message) {
        message.recoverContents();
        message.increaseDeliveryCount();
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.enqueueFirst(message);
            this.messageAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(MessageEventProvider provider, Collection messages) {
        for (ClientMessage message : messages) {
            message.recoverContents();
            message.increaseDeliveryCount();
        }
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.enqueueFirst(messages);
            this.messageAvailable();
        }
    }

    public int queuedWorks() {
        return this.size();
    }

    public boolean delegate() {
        return true;
    }

    public void run() {
        this.workStarted();
        ClientMessage message = this.removeFirstMessage();
        try {
            while (message != null) {
                this.startWork(message);
                message = this.removeFirstMessage();
            }
        }
        catch (RuntimeException e) {
            this.setExecuting(false);
            throw e;
        }
        finally {
            if (this.size() == 0) {
                this.workCompleted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientMessage removeFirstMessage() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            ClientMessage message = this.suspend ? null : this.dequeueFirst();
            this.executing = message != null;
            return message;
        }
    }

    public void workStarted() {
        this.executor = Thread.currentThread();
    }

    private void startWork(ClientMessage message) {
        try {
            this.preExecution(message);
            this.execute(message);
            this.success(message);
        }
        catch (JMSException e) {
            this.exception(message, e);
        }
        catch (Throwable t) {
            this.failed(message, t);
        }
        this.postExecution(message);
    }

    public void preExecution(ClientMessage message) throws JMSException {
    }

    public abstract boolean execute(ClientMessage var1) throws Exception;

    public void success(ClientMessage message) throws JMSException {
    }

    public void postExecution(ClientMessage message) {
    }

    public void exception(ClientMessage message, JMSException e) {
        e.printStackTrace();
    }

    public void failed(ClientMessage message, Throwable t) {
        t.printStackTrace();
    }

    public void workCompleted() {
    }

    public String toString() {
        return (this.suspend ? "X:" : "O:") + (this.initialWork == null ? "" : this.initialWork.toString() + "+") + this.works.size();
    }
}

