/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import jeus.jms.client.util.JeusConnectionFactoryCreator;
import jeus.jms.client.util.JeusDestinationCreator;
import jeus.jms.client.util.MessageProducerInfo;

public class JMSProducerPool {
    private List producerList;
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private boolean running = true;
    private ConnectionInitializer connectionInitializer;

    public JMSProducerPool(ConnectionFactory connectionFactory, Destination destination, int size) {
        this.producerList = new ArrayList(size);
        this.connectionFactory = connectionFactory;
        this.destination = destination;
        this.connectionInitializer = new ConnectionInitializer(size);
        new Thread((Runnable)this.connectionInitializer, "JMSProducerPoolThread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageProducerInfo getMessageProducer() throws JMSException {
        JMSProducerPool jMSProducerPool = this;
        synchronized (jMSProducerPool) {
            while (this.running) {
                int size = this.producerList.size();
                if (size > 0) {
                    return (MessageProducerInfo)this.producerList.remove(size - 1);
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMessageProducer(MessageProducerInfo info) {
        JMSProducerPool jMSProducerPool = this;
        synchronized (jMSProducerPool) {
            this.producerList.add(info);
            this.notify();
        }
    }

    public MessageProducerInfo remakeMessageProducer(MessageProducerInfo info) throws JMSException {
        Connection con = info.getConnection();
        try {
            con.close();
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        this.connectionInitializer.increaseSize(1);
        return this.getMessageProducer();
    }

    private MessageProducerInfo makeMessageProducer() throws JMSException {
        Connection con = this.connectionFactory.createConnection();
        try {
            Session session = con.createSession(false, -1);
            MessageProducer producer = session.createProducer(this.destination);
            producer.setDeliveryMode(1);
            MessageProducerInfo info = new MessageProducerInfo(producer, session, con);
            con.setExceptionListener((ExceptionListener)new JMSExcepionListener(info));
            con.start();
            return info;
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            con.close();
            throw ex;
        }
    }

    public static void main(String[] args) {
        try {
            JeusConnectionFactoryCreator factoryCreatorJeus = new JeusConnectionFactoryCreator();
            factoryCreatorJeus.setFactoryName("JeusConnectionFactory");
            factoryCreatorJeus.addBrokerAddress("61.77.153.26", 9741);
            QueueConnectionFactory qConFactory = (QueueConnectionFactory)factoryCreatorJeus.createConnectionFactory();
            JeusDestinationCreator creator = new JeusDestinationCreator();
            creator.setDestinationName("ExamplesQueue");
            creator.setDestinationClass(Queue.class);
            Queue queue = (Queue)creator.createDestination();
            JMSProducerPool pool = new JMSProducerPool((ConnectionFactory)qConFactory, (Destination)queue, 10);
            MessageProducerInfo info = pool.getMessageProducer();
            while (true) {
                MessageProducer producer = info.getMessageProducer();
                ObjectMessage message = info.getSession().createObjectMessage();
                message.setObject((Serializable)((Object)"Hello World"));
                try {
                    producer.send((Message)message);
                    pool.releaseMessageProducer(info);
                    System.out.println("***** Message sent successfully");
                    Thread.sleep(10000L);
                    System.out.println("***** try to send again");
                }
                catch (JMSException ex) {
                    ex.printStackTrace();
                    System.out.println("***** Message sent failed, try again");
                    info = pool.remakeMessageProducer(info);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    class ConnectionInitializer
    implements Runnable {
        private int createSize;

        public ConnectionInitializer(int createSize) {
            this.createSize = createSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            while (JMSProducerPool.this.running) {
                boolean create;
                boolean bl = create = this.createSize > 0;
                while (create) {
                    try {
                        MessageProducerInfo info = JMSProducerPool.this.makeMessageProducer();
                        Object object = JMSProducerPool.this;
                        synchronized (object) {
                            JMSProducerPool.this.producerList.add(info);
                        }
                        object = this;
                        synchronized (object) {
                            --this.createSize;
                            create = this.createSize > 0;
                        }
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public synchronized void increaseSize(int size) {
            ++this.createSize;
            this.notify();
        }
    }

    class JMSExcepionListener
    implements ExceptionListener {
        private MessageProducerInfo info;

        public JMSExcepionListener(MessageProducerInfo info) {
            this.info = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onException(JMSException e) {
            if (this.info != null) {
                try {
                    JMSProducerPool jMSProducerPool = JMSProducerPool.this;
                    synchronized (jMSProducerPool) {
                        JMSProducerPool.this.producerList.remove(this.info);
                    }
                    Connection con = this.info.getConnection();
                    con.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    this.info = null;
                }
            }
        }
    }
}

