/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common;

import javax.jms.JMSException;
import jeus.jms.common.JMSEntry;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.JMSAsyncRequest;
import jeus.jms.common.util.JMSRequest;
import jeus.jms.common.util.JMSRequestManager;
import jeus.jms.common.util.JMSRouteRequest;
import jeus.jms.common.util.JMSSyncRequest;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.common.util.SerialExecutor;
import jeus.jms.server.comm.JMSBroker;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS1;

public abstract class JMSBaseEntry
implements JMSEntry {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    protected String name;
    protected long id = -1L;
    protected JMSBroker broker = JMSBroker.getLocalBroker();
    protected short brokerID;
    protected String brokerName;
    protected SerialExecutor executor;
    private JMSRequestManager manager;

    public JMSBaseEntry(JMSRequestManager manager, SerialExecutor executor) {
        this.manager = manager;
        this.executor = executor;
    }

    public void init() throws Exception {
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public short getBrokerID() {
        return this.brokerID;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void sendRequestMessage(MessageContainer packet) throws JMSException {
        packet.setRequestFlag(true);
        this.sendData(packet);
    }

    public void sendReplyMessage(MessageContainer packet) throws JMSException {
        packet.setRequestFlag(false);
        this.sendData(packet);
    }

    public void sendNotifyMessage(MessageContainer packet) throws JMSException {
        packet.setObserved(false);
        this.sendData(packet);
    }

    public void sendRequestDirect(MessageContainer packet) throws JMSException {
        packet.setRequestFlag(true);
        this.sendDirect(packet);
    }

    public void sendReplyDirect(MessageContainer packet) throws JMSException {
        packet.setRequestFlag(false);
        this.sendDirect(packet);
    }

    public JMSSyncRequest sendSyncRequest(MessageContainer packet) throws JMSException {
        JMSSyncRequest request = this.registerRequest(packet);
        try {
            this.sendRequestMessage(packet);
            return request;
        }
        catch (JMSException e) {
            this.removeObserver(request.getObserverID());
            throw e;
        }
    }

    public void sendAsyncRequest(MessageHandler handler, MessageContainer packet) throws JMSException {
        this.registerCallbackRequest(handler, packet);
        try {
            this.sendRequestMessage(packet);
        }
        catch (JMSException e) {
            this.removeObserver(packet.getObserverID());
            throw e;
        }
    }

    public void sendRoutingRequest(MessageHandler handler, MessageContainer packet) throws JMSException {
        this.registerRoutingRequest(packet, handler);
        try {
            this.sendRequestMessage(packet);
        }
        catch (JMSException e) {
            JMSRouteRequest routeRequest = (JMSRouteRequest)this.removeObserver(packet.getObserverID());
            routeRequest.messageFailed(packet, e);
        }
    }

    public void sendRoutingRequest(MessageContainer packet) throws JMSException {
        DefaultMessageHandler handler = new DefaultMessageHandler();
        this.sendRoutingRequest(handler, packet);
    }

    public MessageContainer waitSyncReply(JMSSyncRequest request, long timeout) throws JMSException {
        this.flushWorks();
        long remain = timeout < 0L ? 0L : timeout;
        MessageContainer message = request.waitResult(remain);
        if (message == null) {
            this.removeObserver(request.getObserverID());
            throw new JMSException("timeout occurred waiting server response for request " + request);
        }
        return message;
    }

    public MessageContainer sendAndWaitSyncRequest(MessageContainer packet, long timeout) throws JMSException {
        JMSSyncRequest request = this.sendSyncRequest(packet);
        return this.waitSyncReply(request, timeout);
    }

    public MessageContainer recover(MessageContainer packet, long timeout) throws JMSException {
        JMSSyncRequest request = this.registerRequest(packet);
        this.sendRequestDirect(packet);
        return this.waitSyncReply(request, timeout);
    }

    public void sendFailedReply(MessageContainer packet, JMSException e) {
        block4: {
            if (!packet.isRequestMessage()) {
                return;
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1231_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1231_LEVEL, JeusMessage_JMS1._1231, packet, (Throwable)e);
            }
            AdminMessage reply = MessageUtil.createAdminMessage(packet.getMetaHeader());
            reply.setException(e);
            try {
                this.sendReplyMessage(reply);
            }
            catch (JMSException e1) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS1._1232_LEVEL)) break block4;
                LogUtils.log(logger, JeusMessage_JMS1._1232_LEVEL, JeusMessage_JMS1._1232, reply, (Throwable)e1);
            }
        }
    }

    public void failedMessage(MessageContainer packet, JMSException ex) {
        if (!packet.isRequestMessage()) {
            return;
        }
        this.handleFailedMessage(packet, ex);
    }

    public void handleArrivedMessage(MessageContainer packet) {
        if (this.isNeedRouting(packet)) {
            this.handleRoutingRequest(packet);
        } else if (packet.isReplyMessage()) {
            this.handleReplyMessage(packet);
        } else {
            this.handleRequestMessage(packet);
        }
    }

    public void handleReplyMessage(MessageContainer packet) {
        int observerID = packet.getObserverID();
        JMSRequest request = this.removeObserver(observerID);
        if (request == null || !request.messageArrived(packet)) {
            this.handleMissingMessage(packet, null);
        }
    }

    public void handleFailedMessage(MessageContainer packet, JMSException ex) {
        int observerID = packet.getObserverID();
        JMSRequest request = this.removeObserver(observerID);
        if (request != null) {
            request.messageFailed(packet, ex);
        }
    }

    public void handleRoutingRequest(MessageHandler handler, MessageContainer packet) {
        try {
            JMSBaseEntry target = this.getRoutingEntry(packet);
            target.sendRoutingRequest(handler, packet);
        }
        catch (JMSException ex) {
            handler.handleException(packet, ex);
        }
    }

    public void handleRoutingRequest(MessageContainer packet) {
        DefaultMessageHandler handler = new DefaultMessageHandler();
        this.handleRoutingRequest(handler, packet);
    }

    public abstract boolean isNeedRouting(MessageContainer var1);

    public abstract void handleRequestMessage(MessageContainer var1);

    public abstract void handleMissingMessage(MessageContainer var1, JMSException var2);

    public abstract JMSBaseEntry getRoutingEntry(MessageContainer var1) throws JMSException;

    public boolean isValidRequest(int observerID) {
        return this.manager.isValidRequest(observerID);
    }

    protected JMSSyncRequest registerRequest(MessageContainer packet) {
        int observerID = this.manager.getNextObserverID();
        JMSSyncRequest request = new JMSSyncRequest(observerID);
        this.registerObserver(observerID, request);
        packet.setObserverID(observerID);
        return request;
    }

    protected void registerCallbackRequest(MessageHandler handler, MessageContainer packet) {
        int observerID = this.manager.getNextObserverID();
        JMSAsyncRequest request = new JMSAsyncRequest(handler, observerID);
        this.registerObserver(observerID, request);
        packet.setObserverID(observerID);
    }

    protected void registerRoutingRequest(MessageContainer packet, MessageHandler handler) {
        int originalID = packet.getObserverID();
        int observerID = this.manager.getNextObserverID();
        JMSRouteRequest request = new JMSRouteRequest(handler, observerID, originalID);
        this.registerObserver(observerID, request);
        packet.setObserverID(observerID);
    }

    protected void cancelOutBoundRequests() {
        JMSException ex = new JMSException("fail to reconnect : " + this.manager);
        this.manager.cancelObserversByException(ex);
    }

    public void cancelMessageRequest(JMSSyncRequest request) {
        this.manager.cancelObserver(request.getObserverID());
    }

    public void cancelMessageRequest(int observerID) {
        this.manager.cancelObserver(observerID);
    }

    public void cancelMessageRequests() {
        this.manager.cancelObservers();
    }

    private void registerObserver(int observerID, JMSRequest request) {
        this.manager.registerObserver(observerID, request);
    }

    private JMSRequest removeObserver(int observerID) {
        return this.manager.removeObserver(observerID);
    }

    public void clearObserver() {
        this.manager.cancelObservers();
    }

    public void flushWorks() {
    }

    private class DefaultMessageHandler
    implements MessageHandler {
        private DefaultMessageHandler() {
        }

        public void handleMessage(MessageContainer packet) throws JMSException {
            JMSBaseEntry.this.sendReplyMessage(packet);
        }

        public void handleException(MessageContainer packet, JMSException e) {
            JMSBaseEntry.this.sendFailedReply(packet, e);
        }
    }
}

