/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import jeus.jms.common.util.ProtocolUtil;
import jeus.jms.server.comm.JMSBroker;
import jeus.net.impl.NodeInfo;

public class JMSServiceChannelAddress
extends NodeInfo
implements Serializable {
    private static final long serialVersionUID = -8483422331581762526L;
    private static final short ANONYMOUS_BROKER_ID = -1;
    private short brokerID;
    private String brokerName;
    private transient String toString;

    public JMSServiceChannelAddress(String address, int port) {
        super(address, port);
        this.brokerID = (short)-1;
    }

    public JMSServiceChannelAddress(short brokerID, String brokerName, String address, int port) {
        super(address, port);
        this.brokerID = brokerID;
        this.brokerName = brokerName;
    }

    public JMSServiceChannelAddress(short brokerID, String brokerName, String address, int port, String virtualID) {
        super(address, port, virtualID);
        this.brokerID = brokerID;
        this.brokerName = brokerName;
    }

    public static String createVirtualID(String brokerName) {
        return "JMSServiceChannel-" + brokerName;
    }

    public String getServerURL() {
        return super.toString();
    }

    public short getBrokerID() {
        return this.brokerID;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public String getSafeHost() {
        return this.getHost().replace(':', '.');
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.brokerID = in.readShort();
        this.brokerName = in.readUTF();
        this.host = ProtocolUtil.readString(in);
        this.port = in.readInt();
        if (in.available() > 0 && in.readBoolean()) {
            this.virtualID = in.readUTF();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeShort(this.brokerID);
        out.writeUTF(this.brokerName);
        ProtocolUtil.writeString(this.host, out);
        out.writeInt(this.port);
        if (this.virtualID != null) {
            out.writeBoolean(true);
            out.writeUTF(this.virtualID);
        } else {
            out.writeBoolean(false);
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JMSServiceChannelAddress)) {
            return false;
        }
        JMSServiceChannelAddress another = (JMSServiceChannelAddress)obj;
        return super.equals((Object)another);
    }

    public void setBrokerID(short brokerID) {
        this.brokerID = brokerID;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.brokerName + "(" + this.brokerID + ") [" + this.getServerURL() + "]";
        }
        return this.toString;
    }

    public static boolean hasLocalAddress(Collection addresses) {
        for (JMSServiceChannelAddress addr : addresses) {
            if (!JMSBroker.getLocalBroker().isLocalBrokerAddress(addr)) continue;
            return true;
        }
        return false;
    }
}

