/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.common.comm.BrokerSelectionPolicy;

public class ActiveStandbyPolicy
extends BrokerSelectionPolicy {
    private JMSServiceChannelAddress[] iteration;

    public ActiveStandbyPolicy(HashSet addresses) {
        super(addresses);
        this.init();
    }

    private void init() {
        this.iteration = this.addresses.toArray(new JMSServiceChannelAddress[this.addresses.size()]);
        Arrays.sort(this.iteration, new Comparator(){

            public int compare(Object o1, Object o2) {
                JMSServiceChannelAddress addr1 = (JMSServiceChannelAddress)o1;
                JMSServiceChannelAddress addr2 = (JMSServiceChannelAddress)o2;
                return addr1.getBrokerID() - addr2.getBrokerID();
            }
        });
    }

    public Enumeration getServiceChannelAddresses() {
        return Collections.enumeration(Arrays.asList(this.iteration));
    }

    public Enumeration getReconnectServiceChannelAddresses(JMSServiceChannelAddress current) {
        return Collections.enumeration(Arrays.asList(this.iteration));
    }

    public String getBrokerName() {
        return this.iteration[0].getBrokerName();
    }

    public String getType() {
        return "active-standby";
    }
}

