/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

public class ConnectionState {
    public static final int STATUS_CLOSED = 0;
    public static final int STATUS_CLOSING = 1;
    public static final int STATUS_ACTIVE = 2;
    public static final int STATUS_RECOVER = 3;
    private final int value;
    public static final ConnectionState CLOSED = new ConnectionState(0){

        public boolean isChangeableTo(ConnectionState state) {
            return state == ACTIVE;
        }
    };
    public static final ConnectionState CLOSING = new ConnectionState(1){

        public boolean isChangeableTo(ConnectionState state) {
            return state == CLOSED;
        }
    };
    public static final ConnectionState ACTIVE = new ConnectionState(2){

        public boolean isChangeableTo(ConnectionState state) {
            return state == RECOVER || state == CLOSED || state == CLOSING;
        }
    };
    public static final ConnectionState RECOVER = new ConnectionState(3){

        public boolean isChangeableTo(ConnectionState state) {
            return state == ACTIVE || state == CLOSED || state == CLOSING;
        }
    };

    public ConnectionState(int status) {
        this.value = status;
    }

    public int value() {
        return this.value;
    }

    public boolean isChangeableTo(ConnectionState state) {
        return false;
    }

    public String toString() {
        return ConnectionState.getStateString(this.value);
    }

    public static String getStateString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_CLOSED";
            }
            case 2: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_RECOVER";
            }
        }
        return "invalid block status " + status;
    }
}

