/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jeus.jms.common.JMSEnvironmentValues;
import jeus.jms.common.comm.IntermediateMessageAssembler;
import jeus.jms.common.message.FileMessageImpl;
import jeus.jms.common.message.IntermediateReceivedMessage;
import jeus.jms.common.util.MemoryBufferInputStream;
import jeus.nio.ByteBufferWrapper;
import jeus.util.ByteArray;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS1;

public class FileMessageAssembler
implements IntermediateMessageAssembler {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    FileMessageImpl fileMessage;
    File file;
    OutputStream storedOutputStream;
    boolean urlOnly;
    IntermediateReceivedMessage intermediateMessage;
    boolean isServer;

    public FileMessageAssembler(boolean isServer) {
        this.isServer = isServer;
    }

    public boolean assemble(IntermediateReceivedMessage msg) throws IOException {
        try {
            ByteBufferWrapper buffer = msg.getRawPacket();
            MemoryBufferInputStream in = new MemoryBufferInputStream(buffer);
            if (this.fileMessage == null) {
                this.fileMessage = new FileMessageImpl(msg.getMetaHeader());
                this.fileMessage.readHeader(in);
                in.readBoolean();
                this.urlOnly = in.readBoolean();
                this.fileMessage.setURLOnly(this.urlOnly);
                if (this.urlOnly) {
                    this.intermediateMessage = new IntermediateReceivedMessage(msg.getMetaHeader(), ByteBufferWrapper.allocate(0));
                    buffer.position(0);
                } else {
                    this.file = this.getFileLocation(this.fileMessage);
                    if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1091_LEVEL)) {
                        LogUtils.log(logger, JeusMessage_JMS1._1091_LEVEL, JeusMessage_JMS1._1091, new Object[]{this.fileMessage, this.file});
                    }
                    this.storedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
                }
            }
            if (this.urlOnly) {
                this.intermediateMessage.append(msg);
            } else {
                int offset = buffer.position();
                int length = buffer.limit() - offset;
                if (length > 0) {
                    ByteArray data = buffer.array();
                    this.storedOutputStream.write(data.getArray(), data.getOffset(), data.getLength());
                }
            }
            if (!msg.isPartialMessage() || msg.isEOF()) {
                if (!this.urlOnly) {
                    this.storedOutputStream.close();
                    this.fileMessage.setStoredFileURL(this.file.toURL());
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1092_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1092_LEVEL, JeusMessage_JMS1._1092, this.file, (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1093_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1093_LEVEL, JeusMessage_JMS1._1093, this.file, (Throwable)e);
            }
            throw e;
        }
    }

    public IntermediateReceivedMessage getResult() throws IOException {
        if (this.intermediateMessage != null) {
            return this.intermediateMessage;
        }
        return this.fileMessage.getReadableMessage();
    }

    File getFileLocation(FileMessageImpl message) throws IOException {
        String fileName = message.getTargetFileName();
        String baseDir = this.isServer ? JMSEnvironmentValues.getServerFileMsgDir() : JMSEnvironmentValues.getClientWorkDir();
        File baseDirFile = new File(baseDir);
        if (baseDirFile.exists() && !baseDirFile.isDirectory()) {
            throw new IOException("Client working directory '" + baseDirFile.getPath() + "' is not a directory.");
        }
        if (!baseDirFile.exists() && !baseDirFile.mkdirs()) {
            throw new IOException("Unable to create directory '" + baseDirFile.getPath() + "'.");
        }
        return new File(baseDirFile, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileMessageImpl storeFileMessage(FileMessageImpl message) throws IOException {
        if (message.isURLOnly() || message.getURL() == null) {
            return message;
        }
        try {
            this.file = this.getFileLocation(message);
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1094_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1094_LEVEL, JeusMessage_JMS1._1094, new Object[]{message, message.getURL(), this.file});
            }
            BufferedInputStream instream = new BufferedInputStream(message.getURL().openStream());
            this.storedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
            try {
                int b;
                while ((b = instream.read()) != -1) {
                    this.storedOutputStream.write(b);
                }
            }
            finally {
                instream.close();
                this.storedOutputStream.close();
            }
            message.setStoredFileURL(this.file.toURL());
            return message;
        }
        catch (IOException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1095_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1095_LEVEL, JeusMessage_JMS1._1095, this.file, (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1096_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1096_LEVEL, JeusMessage_JMS1._1096, this.file, (Throwable)e);
            }
            throw e;
        }
    }

    public void clear() {
    }
}

