/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import jeus.jms.common.comm.SSLParameterFactory;

public class JDK14SSLParameterFactory
extends SSLParameterFactory {
    public SSLParameterFactory.SSLParameter createSSLParameter(Properties props, boolean authenticate) {
        String keyStoreType = props.getProperty("jeus.jms.ssl.keystore.type", "JKS");
        char[] keyStorePass = props.getProperty("jeus.jms.ssl.keystore.passphrase", "changeit").toCharArray();
        String keyStorePath = props.getProperty("jeus.jms.ssl.keystore.file");
        String keyManagementAlgorithm = props.getProperty("jeus.jms.ssl.keymanagement.algorithm", "SunX509");
        String trustStoreType = props.getProperty("jeus.jms.ssl.truststore.type", "JKS");
        char[] trustStorePass = props.getProperty("jeus.jms.ssl.truststore.passphrase", "changeit").toCharArray();
        String trustStorePath = props.getProperty("jeus.jms.ssl.truststore.file");
        String trustManagementAlgorithm = props.getProperty("jeus.jms.ssl.trustmanagement.algorithm", "SunX509");
        String protocol = props.getProperty("jeus.jms.ssl.protocol", "TLS");
        try {
            File keyStoreFile = new File(keyStorePath);
            if (!keyStoreFile.exists()) {
                throw new IllegalArgumentException("Key store path '" + keyStorePath + "' does not exist.");
            }
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            FileInputStream keyStoreInput = new FileInputStream(keyStoreFile);
            keyStore.load(keyStoreInput, keyStorePass);
            keyStoreInput.close();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagementAlgorithm);
            kmf.init(keyStore, keyStorePass);
            TrustManagerFactory tmf = null;
            if (authenticate) {
                File trustStoreFile = new File(keyStorePath);
                if (!trustStoreFile.exists()) {
                    throw new IllegalArgumentException("Trust store path '" + trustStorePath + "' does not exist.");
                }
                KeyStore trustManagerStore = KeyStore.getInstance(trustStoreType);
                FileInputStream trustManagementStoreInput = new FileInputStream(trustStoreFile);
                trustManagerStore.load(trustManagementStoreInput, trustStorePass);
                trustManagementStoreInput.close();
                tmf = TrustManagerFactory.getInstance(trustManagementAlgorithm);
                tmf.init(trustManagerStore);
            }
            SSLContext ctx = SSLContext.getInstance(protocol);
            ctx.init(kmf.getKeyManagers(), tmf != null ? tmf.getTrustManagers() : null, null);
            return new SSLParameterFactory.SSLParameter(ctx, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

