/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

import java.io.IOException;
import jeus.jms.MessageTransformer;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.JMSRemoteEntry;
import jeus.jms.common.comm.FileMessageAssembler;
import jeus.jms.common.comm.IntermediateMessageAssembler;
import jeus.jms.common.comm.MemoryMessageAssembler;
import jeus.jms.common.message.IntermediateReceivedMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.MemoryBufferInputStream;
import jeus.jms.common.util.Utility;
import jeus.nio.ByteBufferWrapper;
import jeus.util.ByteArray;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS1;

public abstract class MessageFabricator {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    protected static final JeusLogger dumper = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.dump");
    protected JMSRemoteEntry entry;

    protected MessageFabricator(JMSRemoteEntry entry) {
        this.entry = entry;
    }

    public final MessageContainer fabricate(byte[] data) throws IOException {
        return this.fabricate(this.createMessage(data));
    }

    private MessageContainer fabricate(IntermediateReceivedMessage message) throws IOException {
        if (message.isPartialMessage()) {
            IntermediateMessageAssembler assembler = this.acquireAssembler(message);
            if (!assembler.assemble(message)) {
                return null;
            }
            message = assembler.getResult();
            this.assembleCompleted(message);
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1031_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1031_LEVEL, JeusMessage_JMS1._1031, message);
            }
        } else if (!message.isAdminMessage() && message.getMessageType() == 70) {
            FileMessageAssembler assembler = this.createFileMessageAssembler();
            assembler.assemble(message);
            message = assembler.getResult();
        }
        return this.createMessageContainer(message);
    }

    protected IntermediateReceivedMessage createMessage(ByteBufferWrapper buffer) throws IOException {
        ByteBufferWrapper packet;
        if (LogUtils.isLoggable(dumper, JeusMessage_JMS1._1032_LEVEL)) {
            LogUtils.log(dumper, JeusMessage_JMS1._1032_LEVEL, JeusMessage_JMS1._1032, Utility.getDump(buffer, false));
        }
        MemoryBufferInputStream in = new MemoryBufferInputStream(buffer);
        MetaHeader metaHeader = new MetaHeader(in);
        MessageTransformer transformer = JMSProperties.getTransformer();
        int offset = buffer.position();
        if (metaHeader.isTransformed()) {
            if (transformer == null) {
                throw new IOException("Transformed message is arrived but has no transformer");
            }
            ByteArray byteArray = buffer.array();
            byte[] bytes = transformer.unmarshal(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
            packet = bytes != null ? ByteBufferWrapper.wrap(this.entry.useDirectByteBuffer(), bytes) : buffer.slice();
            metaHeader.setTotalLength(offset + packet.capacity());
            metaHeader.setTransformed(false);
        } else {
            packet = buffer.slice();
        }
        return new IntermediateReceivedMessage(metaHeader, packet);
    }

    private IntermediateReceivedMessage createMessage(byte[] data) throws IOException {
        ByteBufferWrapper buffer = ByteBufferWrapper.wrap(this.entry.useDirectByteBuffer(), data);
        return this.createMessage(buffer);
    }

    private synchronized IntermediateMessageAssembler acquireAssembler(IntermediateReceivedMessage message) throws IOException {
        short partialID = message.getPartialID();
        IntermediateMessageAssembler assembler = this.entry.getMessageAssembler(partialID);
        if (assembler == null) {
            assembler = !message.isAdminMessage() && message.getMessageType() == 70 ? this.createFileMessageAssembler() : new MemoryMessageAssembler();
            this.entry.addMessageAssembler(partialID, assembler);
        }
        return assembler;
    }

    private synchronized void assembleCompleted(IntermediateReceivedMessage message) {
        short partialID = message.getPartialID();
        this.entry.removeMessageAssembler(partialID);
        message.setPartialID((short)0);
        message.setPartialSequence(0);
    }

    protected abstract FileMessageAssembler createFileMessageAssembler();

    protected abstract MessageContainer createMessageContainer(IntermediateReceivedMessage var1) throws IOException;
}

