/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.destination;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import javax.naming.Reference;
import javax.naming.Referenceable;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.util.ProtocolUtil;

public abstract class JeusDestination
extends DestinationIdentity
implements Referenceable {
    public static final int DEFAULT_MAX_PENDING_LIMIT = Integer.MAX_VALUE;
    public static final float DEFAULT_RESUME_DISPATCH_FACTOR = 0.4f;
    public static final long NULL_DESTINATION_ID = -1L;
    public static final String NULL_DESTINATION_NAME = "__NULL__";
    private static final int consumerLimitDefault = Integer.MAX_VALUE;
    private static final int lowMarkDefault = 0;
    private static final int highMarkDefault = Integer.MAX_VALUE;
    private static final int limitDefault = Integer.MAX_VALUE;
    private long id;
    private String exportName;
    private int consumerLimit = Integer.MAX_VALUE;
    private int lowMark = 0;
    private int highMark = Integer.MAX_VALUE;
    private int limit = Integer.MAX_VALUE;
    private byte relayType;
    private List relays;
    private int maxPendingLimit = Integer.MAX_VALUE;
    private float resumeDispatchFactor = 0.4f;
    private transient boolean valid = true;
    private transient long version;
    private transient boolean recovered = false;

    public JeusDestination() {
    }

    public JeusDestination(byte type) {
        super(type);
    }

    public JeusDestination(byte type, String brokerName, String name) {
        super(type, brokerName, name);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public int getConsumerLimit() {
        return this.consumerLimit;
    }

    public void setConsumerLimit(int consumerLimit) {
        this.consumerLimit = consumerLimit;
    }

    public int getLowMark() {
        return this.lowMark;
    }

    public void setLowMark(int lowMark) {
        this.lowMark = lowMark;
    }

    public int getHighMark() {
        return this.highMark;
    }

    public void setHighMark(int highMark) {
        this.highMark = highMark;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setRelayType(byte relayType) {
        this.relayType = relayType;
    }

    public byte getRelayType() {
        return this.relayType;
    }

    public List getRelays() {
        return this.relays;
    }

    public void setRelays(List relays) {
        this.relays = relays;
    }

    public float getResumeDispatchFactor() {
        return this.resumeDispatchFactor;
    }

    public void setResumeDispatchFactor(float resumeDispatchFactor) {
        if (resumeDispatchFactor <= 0.0f) {
            throw new IllegalArgumentException("Resume dispatch factory must be greater than zero.");
        }
        this.resumeDispatchFactor = resumeDispatchFactor;
    }

    public int getMaxPendingLimit() {
        return this.maxPendingLimit;
    }

    public void setMaxPendingLimit(int maxPendingLimit) {
        if (maxPendingLimit <= 0) {
            throw new IllegalArgumentException("Maximum pending limit must be greater than zero.");
        }
        this.maxPendingLimit = maxPendingLimit;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void addClusterPeer(String peerName) {
        this.relays.add(peerName);
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public void setRecovered(boolean recovered) {
        this.recovered = recovered;
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.exportName = ProtocolUtil.readString(in);
        this.consumerLimit = in.readInt();
        this.lowMark = in.readInt();
        this.highMark = in.readInt();
        this.limit = in.readInt();
        this.relays = ProtocolUtil.readStringList(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ProtocolUtil.writeString(this.exportName, out);
        out.writeInt(this.consumerLimit);
        out.writeInt(this.lowMark);
        out.writeInt(this.highMark);
        out.writeInt(this.limit);
        ProtocolUtil.writeStringList(this.relays, out);
    }

    public Reference getReference() {
        Reference ref = this.createReference();
        this.addReferenceInfo(ref);
        return ref;
    }

    protected abstract Reference createReference();
}

