/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.destination;

import javax.jms.JMSException;
import jeus.jms.client.facility.connection.JeusConnection;
import jeus.jms.client.facility.consumer.JeusLocalMessageConsumer;
import jeus.jms.common.destination.DestinationIdentity;

public abstract class TemporaryDestination
extends DestinationIdentity {
    protected transient JeusConnection connection;

    public TemporaryDestination(byte type) {
        super(type);
    }

    public TemporaryDestination(byte type, String brokerName, String localName) {
        super(type, brokerName, localName);
    }

    public TemporaryDestination(byte type, String brokerName, String localName, JeusConnection connection) {
        super(type, brokerName, localName);
        this.connection = connection;
        this.setTemporaryID(connection.getEntryID());
        this.setTemporaryConnctionID(connection.getConnectionID());
    }

    public JeusConnection getConnection() {
        return this.connection;
    }

    public void delete() throws JMSException {
        if (this.connection == null) {
            throw new JMSException("temporary queue is not owned by current client");
        }
        this.connection.removeTemporaryDestination(this);
    }

    public void consumerClosed(JeusLocalMessageConsumer consumer) {
        this.connection.consumerClosed(this, consumer);
    }
}

