/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jeus.jms.common.event.ParamValue;

public class ParamSet {
    HashMap contentMap;

    public ParamSet() {
        this.contentMap = new HashMap();
    }

    public ParamSet(HashMap contentMap) {
        this.contentMap = contentMap;
    }

    public ParamValue getValue(String key) {
        return new ParamValue(this.contentMap.get(key));
    }

    public Object get(String key) {
        return this.contentMap.get(key);
    }

    public void setBooleanValue(String name, boolean value) {
        this.checkArgument(name);
        this.contentMap.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setShortValue(String name, short value) {
        this.checkArgument(name);
        this.contentMap.put(name, new Short(value));
    }

    public void setIntValue(String name, int value) {
        this.checkArgument(name);
        this.contentMap.put(name, new Integer(value));
    }

    public void setLongValue(String name, long value) {
        this.checkArgument(name);
        this.contentMap.put(name, new Long(value));
    }

    public void setDoubleValue(String name, double value) {
        this.checkArgument(name);
        this.contentMap.put(name, new Double(value));
    }

    public void setFloatValue(String name, float value) {
        this.checkArgument(name);
        this.contentMap.put(name, new Float(value));
    }

    public void setStringValue(String name, String value) {
        this.checkArgument(name);
        this.contentMap.put(name, value);
    }

    public void setObjectValue(String name, Object value) {
        this.checkArgument(name);
        this.contentMap.put(name, value);
    }

    public void setAll(Map map) {
        this.contentMap.putAll(map);
    }

    public Map getAll() {
        return this.contentMap;
    }

    public Set getNames() {
        return this.contentMap.keySet();
    }

    public void checkArgument(String name) throws IllegalArgumentException {
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException();
        }
    }
}

