/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import javax.jms.MessageNotWriteableException;
import jeus.jms.FileMessage;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.IntermediateReceivedMessage;
import jeus.jms.common.message.IntermediateSendMessage;
import jeus.jms.common.message.MessageFactory;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.UserMessage;
import jeus.jms.common.util.ProtocolUtil;
import jeus.jms.common.util.Utility;
import jeus.jms.server.JMSServer;
import jeus.jms.server.manager.ClusterManager;
import jeus.nio.ByteBufferWrapper;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS1;

public class FileMessageImpl
extends ClientMessage
implements FileMessage,
Cloneable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    protected URL url;
    protected boolean urlOnly;

    public FileMessageImpl() {
        super((byte)70);
    }

    public FileMessageImpl(URL url) {
        this();
        this.url = url;
    }

    public FileMessageImpl(MetaHeader metaHeader) {
        super(metaHeader);
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) throws MessageNotWriteableException {
        this.checkOutputStream();
        this.url = url;
    }

    public void setStoredFileURL(URL url) {
        this.url = url;
        this.urlOnly = true;
    }

    public boolean isURLOnly() {
        return this.urlOnly;
    }

    public void setURLOnly(boolean urlOnly) {
        this.urlOnly = urlOnly;
    }

    void marshal(DataOutput out) throws IOException {
        boolean sendUrlOnly = this.urlOnly || this.url == null;
        out.writeBoolean(sendUrlOnly);
        if (sendUrlOnly) {
            String str = this.url == null ? null : this.url.toString();
            ProtocolUtil.writeString(str, out);
        }
    }

    protected IntermediateSendMessage createIntermediateMessage(ByteBufferWrapper buffer) {
        try {
            return new FileIntermediateMessage(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void unmarshal(DataInput in) throws IOException {
        String str;
        this.urlOnly = in.readBoolean();
        if (this.urlOnly && (str = ProtocolUtil.readString(in)) != null) {
            this.url = new URL(str);
        }
    }

    public String getTargetFileName() {
        DestinationIdentity destId = this.getHeader().getDestination();
        String f = ClusterManager.LOCAL_BROKER_NAME + "_" + JMSServer.getServerStartTime() + "_" + destId.getLocalName() + "_" + this.getMessageID().getJMSMessageID();
        String fileName = f.replace(':', '_');
        return fileName;
    }

    public void clearBody() {
        this.url = null;
        super.clearBody();
    }

    public Object clone() {
        FileMessageImpl message = (FileMessageImpl)this.getMessageClone();
        message.url = this.url;
        return message;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",url={");
        b.append(this.url == null ? "null" : this.url.toString());
        b.append("}");
        return b.toString();
    }

    public IntermediateReceivedMessage getReadableMessage() throws IOException {
        ByteBufferWrapper buffer = MessageFactory.serializeForWrite(this);
        return new IntermediateReceivedMessage(this.metaHeader, buffer);
    }

    private class FileIntermediateMessage
    extends IntermediateSendMessage {
        private BufferedInputStream instream;
        public short partialSeq;

        public FileIntermediateMessage(ByteBufferWrapper buffer) throws IOException {
            super(buffer, FileMessageImpl.this);
            this.instream = new BufferedInputStream(FileMessageImpl.this.url.openStream());
        }

        public synchronized ByteBufferWrapper[] getWritablePacket(boolean direct) throws IOException {
            try {
                ByteBufferWrapper[] byteBuffers;
                boolean isDataAvailable;
                boolean sendUrlOnly;
                boolean bl = sendUrlOnly = FileMessageImpl.this.urlOnly || FileMessageImpl.this.url == null;
                if (!this.isAlreadySent) {
                    if (!sendUrlOnly) {
                        this.metaHeader.setPartialID(JMSProperties.getNextPartialID());
                        short s = this.partialSeq;
                        this.partialSeq = (short)(s + 1);
                        this.metaHeader.setPartialSequence(s);
                    }
                    return super.getWritablePacket(direct);
                }
                if (sendUrlOnly) {
                    return null;
                }
                if (this.instream == null) {
                    return null;
                }
                byte[] dataBytes = new byte[JMSProperties.FILE_MESSAGE_BLOCK_SIZE];
                short s = this.partialSeq;
                this.partialSeq = (short)(s + 1);
                this.metaHeader.setPartialSequence(s);
                int dataLength = this.instream.read(dataBytes);
                boolean bl2 = isDataAvailable = dataLength > 0;
                if (dataLength < dataBytes.length) {
                    this.closeInstream();
                    this.metaHeader.setPartialEOF();
                }
                if (isDataAvailable && this.transformer != null) {
                    byte[] bytes;
                    if (JMSProperties.DEBUG_TRANSFORMER && LogUtils.isLoggable(logger, JeusMessage_JMS1._1291_LEVEL)) {
                        LogUtils.log(logger, JeusMessage_JMS1._1291_LEVEL, JeusMessage_JMS1._1291, StringUtil.lineSeparator + Utility.getDump(dataBytes, 0, dataLength));
                    }
                    if ((bytes = this.transformer.marshal(dataBytes, 0, dataLength, (UserMessage)this.message)) != null) {
                        if (JMSProperties.DEBUG_TRANSFORMER && LogUtils.isLoggable(logger, JeusMessage_JMS1._1292_LEVEL)) {
                            LogUtils.log(logger, JeusMessage_JMS1._1292_LEVEL, JeusMessage_JMS1._1292, StringUtil.lineSeparator + Utility.getDump(bytes));
                        }
                        dataBytes = bytes;
                        this.metaHeader.setTransformed(true);
                    } else if (JMSProperties.DEBUG_TRANSFORMER && LogUtils.isLoggable(logger, JeusMessage_JMS1._1293_LEVEL)) {
                        LogUtils.log(logger, JeusMessage_JMS1._1293_LEVEL, JeusMessage_JMS1._1293);
                    }
                }
                ByteBufferWrapper header = MessageFactory.serializeForWrite(this.metaHeader, 52);
                int length = header.remaining();
                if (isDataAvailable) {
                    ByteBufferWrapper data = ByteBufferWrapper.wrap(direct, dataBytes);
                    data.limit(dataLength);
                    length += data.remaining();
                    byteBuffers = new ByteBufferWrapper[]{header, data};
                } else {
                    byteBuffers = new ByteBufferWrapper[]{header};
                }
                header.putInt(4, length);
                this.metaHeader.setTotalLength(length);
                return byteBuffers;
            }
            catch (IOException ex) {
                this.closeInstream();
                throw ex;
            }
            catch (RuntimeException ex) {
                this.closeInstream();
                throw ex;
            }
            catch (Error ex) {
                this.closeInstream();
                throw ex;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeInstream() throws IOException {
            if (this.instream != null) {
                try {
                    this.instream.close();
                }
                finally {
                    this.instream = null;
                }
            }
        }

        public void done() {
            try {
                this.closeInstream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.done();
        }
    }
}

