/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import jeus.jms.common.message.BytesMessageImpl;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.EmptyMessage;
import jeus.jms.common.message.MapMessageImpl;
import jeus.jms.common.message.ObjectMessageImpl;
import jeus.jms.common.message.StreamMessageImpl;
import jeus.jms.common.message.TextMessageImpl;
import jeus.jms.common.message.UserMessage;

public class MessageConversion {
    private static void copyMessageProperty(Message from, UserMessage to) throws JMSException {
        Enumeration enum1 = from.getPropertyNames();
        while (enum1.hasMoreElements()) {
            String item = (String)enum1.nextElement();
            to.setObjectProperty(item, from.getObjectProperty(item));
        }
        to.setJMSDestination(from.getJMSDestination());
        to.setJMSDeliveryMode(from.getJMSDeliveryMode());
        to.setJMSExpiration(from.getJMSExpiration());
        to.setJMSPriority(from.getJMSPriority());
        to.setJMSTimestamp(from.getJMSTimestamp());
        to.setJMSCorrelationID(from.getJMSCorrelationID());
        to.setJMSReplyTo(from.getJMSReplyTo());
        to.setJMSType(from.getJMSType());
        to.setJMSRedelivered(from.getJMSRedelivered());
    }

    private static void setByteMessage(BytesMessage fromMsg, BytesMessage toMsg) throws JMSException {
        int toReadLength = 1024;
        byte[] dataBuffer = new byte[toReadLength];
        try {
            fromMsg.reset();
            int actualReadLength = fromMsg.readBytes(dataBuffer);
            while (actualReadLength > 0) {
                toMsg.writeBytes(dataBuffer, 0, actualReadLength);
                actualReadLength = fromMsg.readBytes(dataBuffer);
            }
        }
        catch (Exception ex) {
            throw new JMSException("Error while transforming ByteMessage");
        }
    }

    private static void setMapMessage(MapMessage fromMsg, MapMessage toMsg) throws JMSException {
        Enumeration enum1 = fromMsg.getMapNames();
        while (enum1.hasMoreElements()) {
            String item = (String)enum1.nextElement();
            toMsg.setObject(item, fromMsg.getObject(item));
        }
    }

    private static void setStreamMessage(StreamMessage fromMsg, StreamMessage toMsg) {
        try {
            fromMsg.reset();
        }
        catch (JMSException ex) {
            // empty catch block
        }
        try {
            while (true) {
                Object obj = fromMsg.readObject();
                toMsg.writeObject(obj);
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    public static ClientMessage transformMessage(Message message) throws JMSException {
        ClientMessage newMsg;
        if (message instanceof TextMessage) {
            newMsg = new TextMessageImpl(((TextMessage)message).getText());
        } else if (message instanceof BytesMessage) {
            newMsg = new BytesMessageImpl();
            MessageConversion.setByteMessage((BytesMessage)message, (BytesMessage)newMsg);
        } else if (message instanceof MapMessage) {
            newMsg = new MapMessageImpl();
            MessageConversion.setMapMessage((MapMessage)message, (MapMessage)newMsg);
        } else if (message instanceof ObjectMessage) {
            newMsg = new ObjectMessageImpl(((ObjectMessage)message).getObject());
        } else if (message instanceof StreamMessage) {
            newMsg = new StreamMessageImpl();
            MessageConversion.setStreamMessage((StreamMessage)message, (StreamMessage)newMsg);
        } else {
            newMsg = new EmptyMessage();
        }
        MessageConversion.copyMessageProperty(message, newMsg);
        return newMsg;
    }
}

