/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import jeus.jms.common.util.ProtocolUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JMS;

public class MessageFieldEntry {
    private byte type;
    private Object value;

    MessageFieldEntry(byte type, Object value) {
        this.type = type;
        this.value = value;
    }

    MessageFieldEntry(DataInput in) throws IOException {
        this.unmarshal(in);
    }

    public Object getValue() {
        return this.value;
    }

    void marshal(DataOutput out) throws IOException {
        out.writeByte(this.type);
        switch (this.type) {
            case 6: {
                ProtocolUtil.writeString((String)this.value, out);
                break;
            }
            case 3: {
                out.writeByte(((Byte)this.value).byteValue());
                break;
            }
            case 5: {
                out.writeDouble((Double)this.value);
                break;
            }
            case 4: {
                out.writeFloat(((Float)this.value).floatValue());
                break;
            }
            case 1: {
                out.writeInt((Integer)this.value);
                break;
            }
            case 7: {
                out.writeLong((Long)this.value);
                break;
            }
            case 8: {
                out.writeShort(((Short)this.value).shortValue());
                break;
            }
            case 2: {
                out.writeBoolean((Boolean)this.value);
                break;
            }
            case 9: {
                out.writeChar(((Character)this.value).charValue());
                break;
            }
            case 10: {
                ProtocolUtil.writeBytes((byte[])this.value, out);
                break;
            }
            default: {
                throw new IOException("invalid type " + this.type);
            }
        }
    }

    void unmarshal(DataInput in) throws IOException {
        this.type = in.readByte();
        switch (this.type) {
            case 1: {
                this.value = new Integer(in.readInt());
                break;
            }
            case 2: {
                this.value = new Boolean(in.readBoolean());
                break;
            }
            case 3: {
                this.value = new Byte(in.readByte());
                break;
            }
            case 4: {
                this.value = new Float(in.readFloat());
                break;
            }
            case 5: {
                this.value = new Double(in.readDouble());
                break;
            }
            case 6: {
                this.value = ProtocolUtil.readString(in);
                break;
            }
            case 7: {
                this.value = new Long(in.readLong());
                break;
            }
            case 8: {
                this.value = new Short(in.readShort());
                break;
            }
            case 9: {
                this.value = new Character(in.readChar());
                break;
            }
            case 10: {
                this.value = ProtocolUtil.readBytes(in);
                break;
            }
            default: {
                throw new IOException("invalid type " + this.type + " is contained in stream");
            }
        }
    }

    public boolean getBoolean() throws JMSException {
        if (this.value == null) {
            return new Boolean(null);
        }
        switch (this.type) {
            case 2: {
                return (Boolean)this.value;
            }
            case 6: {
                return new Boolean((String)this.value);
            }
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
    }

    public byte getByte() throws JMSException {
        if (this.value == null) {
            return Byte.valueOf(null);
        }
        switch (this.type) {
            case 3: {
                return (Byte)this.value;
            }
            case 6: {
                return Byte.valueOf((String)this.value);
            }
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
    }

    public short getShort() throws JMSException {
        if (this.value == null) {
            return Short.valueOf(null);
        }
        switch (this.type) {
            case 3: {
                return ((Byte)this.value).shortValue();
            }
            case 8: {
                return (Short)this.value;
            }
            case 6: {
                return Short.valueOf((String)this.value);
            }
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
    }

    public char getChar() throws JMSException {
        if (this.type == 9) {
            return ((Character)this.value).charValue();
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
    }

    public int getInt() throws JMSException {
        if (this.value == null) {
            return Integer.valueOf(null);
        }
        switch (this.type) {
            case 3: {
                return ((Byte)this.value).intValue();
            }
            case 8: {
                return ((Short)this.value).intValue();
            }
            case 1: {
                return (Integer)this.value;
            }
            case 6: {
                return Integer.valueOf((String)this.value);
            }
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
    }

    public long getLong() throws JMSException {
        if (this.value == null) {
            return Long.valueOf(null);
        }
        switch (this.type) {
            case 3: {
                return ((Byte)this.value).longValue();
            }
            case 8: {
                return ((Short)this.value).longValue();
            }
            case 1: {
                return ((Integer)this.value).longValue();
            }
            case 7: {
                return (Long)this.value;
            }
            case 6: {
                return Long.valueOf((String)this.value);
            }
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
    }

    public float getFloat() throws JMSException {
        if (this.value == null) {
            return Float.valueOf(null).floatValue();
        }
        switch (this.type) {
            case 4: {
                return ((Float)this.value).floatValue();
            }
            case 6: {
                return Float.valueOf((String)this.value).floatValue();
            }
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
    }

    public double getDouble() throws JMSException {
        if (this.value == null) {
            return Double.valueOf(null);
        }
        switch (this.type) {
            case 4: {
                return ((Float)this.value).doubleValue();
            }
            case 5: {
                return (Double)this.value;
            }
            case 6: {
                return Double.valueOf((String)this.value);
            }
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
    }

    public String getString() throws JMSException {
        switch (this.type) {
            case 6: {
                return (String)this.value;
            }
            case 10: {
                throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
            }
        }
        return this.value.toString();
    }

    public byte[] getBytes() throws JMSException {
        return this.getBytes(true);
    }

    public byte[] getBytes(boolean copy) throws JMSException {
        if (this.type == 10) {
            return this._getBytes(copy);
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
    }

    private byte[] _getBytes(boolean copy) {
        if (this.value == null) {
            return null;
        }
        byte[] result = (byte[])this.value;
        if (copy) {
            byte[] array = new byte[result.length];
            System.arraycopy(result, 0, array, 0, result.length);
            return array;
        }
        return result;
    }

    public Object getObject() throws JMSException {
        switch (this.type) {
            case 2: {
                return (Boolean)this.value;
            }
            case 3: {
                return (Byte)this.value;
            }
            case 8: {
                return (Short)this.value;
            }
            case 1: {
                return (Integer)this.value;
            }
            case 7: {
                return (Float)this.value;
            }
            case 4: {
                return (Double)this.value;
            }
            case 5: {
                return (Boolean)this.value;
            }
            case 6: {
                return (String)this.value;
            }
            case 10: {
                return this._getBytes(true);
            }
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4240));
    }

    public String toString() {
        return this.type + ":" + this.value;
    }
}

