/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import jeus.jms.FileMessage;

public class MessageInfo
implements Serializable {
    private static final long serialVersionUID = -9164984629038723470L;
    public static final byte EMPTY_MESSAGE_TYPE = 69;
    public static final byte BYTES_MESSAGE_TYPE = 66;
    public static final byte MAP_MESSAGE_TYPE = 77;
    public static final byte OBJECT_MESSAGE_TYPE = 79;
    public static final byte STREAM_MESSAGE_TYPE = 83;
    public static final byte TEXT_MESSAGE_TYPE = 84;
    public static final byte FILE_MESSAGE_TYPE = 70;
    public int messageType;
    public long createdTime;
    public String messageID;
    public boolean delivered;

    public String getMessageType() {
        return MessageInfo.getMessageType(this.messageType);
    }

    public static String getMessageType(int messageType) {
        switch (messageType) {
            case 77: {
                return "Map";
            }
            case 66: {
                return "Bytes";
            }
            case 79: {
                return "Object";
            }
            case 83: {
                return "Stream";
            }
            case 84: {
                return "Text";
            }
            case 69: {
                return "Empty";
            }
            case 70: {
                return "File";
            }
        }
        return "Unknown";
    }

    public static MessageInfo createMessageInfo(Message msg) throws JMSException {
        if (msg instanceof BytesMessage) {
            return MessageInfo.createMessageInfo((byte)66, msg);
        }
        if (msg instanceof MapMessage) {
            return MessageInfo.createMessageInfo((byte)77, msg);
        }
        if (msg instanceof ObjectMessage) {
            return MessageInfo.createMessageInfo((byte)79, msg);
        }
        if (msg instanceof StreamMessage) {
            return MessageInfo.createMessageInfo((byte)83, msg);
        }
        if (msg instanceof TextMessage) {
            return MessageInfo.createMessageInfo((byte)84, msg);
        }
        if (msg instanceof FileMessage) {
            return MessageInfo.createMessageInfo((byte)70, msg);
        }
        return MessageInfo.createMessageInfo((byte)69, msg);
    }

    public static MessageInfo createMessageInfo(byte type, Message msg) throws JMSException {
        MessageInfo info = new MessageInfo();
        info.messageType = type;
        info.messageID = msg.getJMSMessageID();
        info.createdTime = msg.getJMSTimestamp();
        info.delivered = msg.getJMSRedelivered();
        return info;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(48);
        buffer.append(this.messageID).append('(').append(this.getMessageType()).append(')').append("created=").append(this.createdTime);
        return buffer.toString();
    }
}

