/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import jeus.jms.common.message.ISerializable;
import jeus.jms.common.util.EnumerationSet;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.ProtocolUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JMS;

public class MessageProperty
extends HashMap
implements ISerializable {
    public static final String JEUS_PROPERTY = "JMS_JEUS_";
    public static final String SCHEDULE = "JMS_JEUS_Schedule";
    public static final String REDELIVERY_LIMIT = "JMS_JEUS_RedeliveryLimit";
    public static final String COMPACTION = "JMS_JEUS_Compaction";
    public static final String MSG_TRACE = "JMS_JEUS_Trace";

    public MessageProperty() {
    }

    public MessageProperty(Map m) {
        super(m);
    }

    boolean getBooleanProperty(String name) throws JMSException {
        Object temp = this.get(name);
        if (temp == null) {
            return Boolean.valueOf(null);
        }
        if (temp instanceof Boolean) {
            return (Boolean)temp;
        }
        if (temp instanceof String) {
            return Boolean.valueOf((String)temp);
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4228));
    }

    byte getByteProperty(String name) throws JMSException {
        Object temp = this.get(name);
        if (temp == null) {
            return Byte.valueOf(null);
        }
        if (temp instanceof Byte) {
            return (Byte)temp;
        }
        if (temp instanceof String) {
            return Byte.valueOf((String)temp);
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4228));
    }

    short getShortProperty(String name) throws JMSException {
        Object temp = this.get(name);
        if (temp == null) {
            return Short.valueOf(null);
        }
        if (temp instanceof Short) {
            return (Short)temp;
        }
        if (temp instanceof Byte) {
            return ((Byte)temp).shortValue();
        }
        if (temp instanceof String) {
            return Short.valueOf((String)temp);
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4228));
    }

    int getIntProperty(String name) throws JMSException {
        Object temp = this.get(name);
        if (temp == null) {
            return Integer.valueOf(null);
        }
        if (temp instanceof Integer) {
            return (Integer)temp;
        }
        if (temp instanceof Byte) {
            return ((Byte)temp).intValue();
        }
        if (temp instanceof Short) {
            return ((Short)temp).intValue();
        }
        if (temp instanceof String) {
            return Integer.valueOf((String)temp);
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4228));
    }

    long getLongProperty(String name) throws JMSException {
        Object temp = this.get(name);
        if (temp == null) {
            return Long.valueOf(null);
        }
        if (temp instanceof Long) {
            return (Long)temp;
        }
        if (temp instanceof Byte) {
            return ((Byte)temp).longValue();
        }
        if (temp instanceof Short) {
            return ((Short)temp).longValue();
        }
        if (temp instanceof Integer) {
            return ((Integer)temp).longValue();
        }
        if (temp instanceof String) {
            return Long.valueOf((String)temp);
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4228));
    }

    float getFloatProperty(String name) throws JMSException {
        Object temp = this.get(name);
        if (temp == null) {
            return Float.valueOf(null).floatValue();
        }
        if (temp instanceof Float) {
            return ((Float)temp).floatValue();
        }
        if (temp instanceof String) {
            return Float.valueOf((String)temp).floatValue();
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4228));
    }

    double getDoubleProperty(String name) throws JMSException {
        Object temp = this.get(name);
        if (temp == null) {
            return Double.valueOf(null);
        }
        if (temp instanceof Double) {
            return (Double)temp;
        }
        if (temp instanceof Float) {
            return ((Float)temp).doubleValue();
        }
        if (temp instanceof String) {
            return Double.valueOf((String)temp);
        }
        throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4228));
    }

    String getStringProperty(String name) throws JMSException {
        Object temp = this.get(name);
        if (temp == null) {
            return null;
        }
        if (temp instanceof String) {
            return (String)temp;
        }
        return temp.toString();
    }

    Object getObjectProperty(String name) throws JMSException {
        return this.get(name);
    }

    Enumeration getPropertyNames() throws JMSException {
        Set key = this.keySet();
        return new EnumerationSet(key);
    }

    void setBooleanProperty(String name, boolean value) {
        this.checkArgument(name);
        this.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    void setByteProperty(String name, byte value) {
        this.checkArgument(name);
        this.put(name, new Byte(value));
    }

    void setShortProperty(String name, short value) {
        this.checkArgument(name);
        this.put(name, new Short(value));
    }

    void setIntProperty(String name, int value) {
        this.checkArgument(name);
        this.put(name, new Integer(value));
    }

    void setLongProperty(String name, long value) {
        this.checkArgument(name);
        this.put(name, new Long(value));
    }

    void setFloatProperty(String name, float value) {
        this.checkArgument(name);
        this.put(name, new Float(value));
    }

    void setDoubleProperty(String name, double value) {
        this.checkArgument(name);
        this.put(name, new Double(value));
    }

    void setStringProperty(String name, String value) {
        this.checkArgument(name);
        this.put(name, value);
    }

    void setObjectProperty(String name, Object value) throws JMSException {
        this.checkArgument(name);
        if (!(value == null || value instanceof String || value instanceof Byte || value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Boolean)) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4223, null, 8);
        }
        this.put(name, value);
    }

    private void checkArgument(String name) throws IllegalArgumentException {
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._3130));
        }
    }

    public void readExternal(DataInput in) throws IOException {
        this.clear();
        int size = in.readInt();
        while (size-- > 0) {
            String name = ProtocolUtil.readString(in);
            byte type = in.readByte();
            switch (type) {
                case 1: {
                    this.put(name, new Integer(in.readInt()));
                    break;
                }
                case 2: {
                    this.put(name, in.readBoolean() ? Boolean.TRUE : Boolean.FALSE);
                    break;
                }
                case 3: {
                    this.put(name, new Byte(in.readByte()));
                    break;
                }
                case 4: {
                    this.put(name, new Float(in.readFloat()));
                    break;
                }
                case 5: {
                    this.put(name, new Double(in.readDouble()));
                    break;
                }
                case 6: {
                    this.put(name, ProtocolUtil.readString(in));
                    break;
                }
                case 7: {
                    this.put(name, new Long(in.readLong()));
                    break;
                }
                case 8: {
                    this.put(name, new Short(in.readShort()));
                    break;
                }
            }
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.size());
        for (String name : this.keySet()) {
            Object value = this.get(name);
            ProtocolUtil.writeString(name, out);
            if (value == null) {
                out.writeByte(6);
                ProtocolUtil.writeString((String)value, out);
                continue;
            }
            if (value instanceof String) {
                out.writeByte(6);
                ProtocolUtil.writeString((String)value, out);
                continue;
            }
            if (value instanceof Byte) {
                out.writeByte(3);
                out.writeByte(((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Double) {
                out.writeByte(5);
                out.writeDouble((Double)value);
                continue;
            }
            if (value instanceof Float) {
                out.writeByte(4);
                out.writeFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Integer) {
                out.writeByte(1);
                out.writeInt((Integer)value);
                continue;
            }
            if (value instanceof Long) {
                out.writeByte(7);
                out.writeLong((Long)value);
                continue;
            }
            if (value instanceof Short) {
                out.writeByte(8);
                out.writeShort(((Short)value).shortValue());
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            out.writeByte(2);
            out.writeBoolean((Boolean)value);
        }
    }

    public MessageProperty getClone() {
        MessageProperty clone = new MessageProperty();
        for (Map.Entry e : this.entrySet()) {
            clone.put(e.getKey(), e.getValue());
        }
        return clone;
    }
}

