/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.ISerializable;
import jeus.jms.common.message.InvalidMagicNumberException;

public class MetaHeader
implements ISerializable,
Cloneable {
    public static final int MAX_SIZE = 52;
    private static final byte NO_ID = -1;
    public static final int MAGIC_NUMBER = 376006416;
    public static final int SIZE_FIELD_INDEX = 4;
    private int totalLength;
    public static final short NOT_PARTIAL = 0;
    public static final short NOT_IN_GROUP = 0;
    private static final int OBSERVER_FLAG = 1;
    private static final int REQUEST_FLAG = 2;
    private static final int SERVER_ROUTING_FLAG = 4;
    private static final int CLIENT_ROUTING_FLAG = 8;
    private static final int AGENCY_FLAG = 16;
    private static final int GROUP_FLAG = 32;
    private static final int PARTIAL_FLAG = 64;
    private static final int ADMIN_FLAG = 128;
    private static final int REDELIVERED_FLAG = 256;
    private static final int TRANSFORMED_FLAG = 512;
    private int metaInfo;
    private short partialID = 0;
    private int partialSeq = 0;
    private short groupID = 0;
    private int groupSeq = 0;
    private int observerID = -1;
    private static final byte RECOVERED_FLAG = 1;
    private static final byte ENTRY_FLAG = 2;
    private static final byte CONNECTION_FLAG = 4;
    private static final byte SESSION_FLAG = 8;
    private static final byte CONSUMER_FLAG = 16;
    private static final byte PRODUCER_FLAG = 32;
    private static final byte BROKER_FLAG = 64;
    public static final byte BROKER = 64;
    public static final byte ENTRY = 3;
    public static final byte CONNECTION_RECOVER = 6;
    public static final byte CONNECTION = 7;
    public static final byte SESSION_RECOVER = 14;
    public static final byte SESSION = 15;
    public static final byte CONNECTION_CONSUMER_RECOVER = 22;
    public static final byte CONNECTION_CONSUMER = 23;
    public static final byte CONSUMER_RECOVER = 30;
    public static final byte CONSUMER = 31;
    public static final byte PRODUCER_RECOVER = 46;
    public static final byte PRODUCER = 47;
    private byte targetID;
    private short brokerID;
    private long entryID = -1L;
    private int connectionID = -1;
    private int sessionID = -1;
    private int consumerID = -1;
    private int producerID = -1;
    private byte msgType;
    private transient boolean direct;
    private transient boolean delayed;
    private transient boolean localConsume;

    public MetaHeader() {
    }

    public MetaHeader(byte type) {
        this.msgType = type;
    }

    public MetaHeader(DataInput in) throws IOException {
        this.readExternal(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(376006416);
        out.writeInt(this.totalLength);
        out.writeInt(this.metaInfo);
        out.writeByte(this.targetID);
        this.writeMetaInfo(out);
        this.writeTargetInfo(out);
        out.writeByte(this.msgType);
    }

    public void readExternal(DataInput in) throws IOException {
        int magic = in.readInt();
        if (magic != 376006416) {
            throw new InvalidMagicNumberException("invalid magic number " + magic);
        }
        this.totalLength = in.readInt();
        this.metaInfo = in.readInt();
        this.targetID = in.readByte();
        this.readMetaInfo(in);
        this.readTargetInfo(in);
        this.msgType = in.readByte();
    }

    public void copyFrom(MetaHeader metaHeader) {
        this.totalLength = metaHeader.totalLength;
        this.metaInfo = metaHeader.metaInfo;
        this.partialID = metaHeader.partialID;
        this.partialSeq = metaHeader.partialSeq;
        this.groupID = metaHeader.groupID;
        this.groupSeq = metaHeader.groupSeq;
        this.observerID = metaHeader.observerID;
        this.targetID = metaHeader.targetID;
        this.brokerID = metaHeader.brokerID;
        this.entryID = metaHeader.entryID;
        this.connectionID = metaHeader.connectionID;
        this.sessionID = metaHeader.sessionID;
        this.consumerID = metaHeader.consumerID;
        this.producerID = metaHeader.producerID;
        this.msgType = metaHeader.msgType;
        this.localConsume = metaHeader.localConsume;
    }

    public MetaHeader getClone() {
        return (MetaHeader)this.clone();
    }

    public Object clone() {
        MetaHeader header = new MetaHeader();
        header.copyFrom(this);
        return header;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(32);
        b.append('T').append(this.getLocalTargetID()).append(this.isSetBroker() ? "(" + this.brokerID + ")" : "");
        b.append(":").append(this.entryID < 0L ? "x" : String.valueOf(this.entryID));
        b.append(":").append(this.connectionID < 0 ? "x" : String.valueOf(this.connectionID));
        b.append(":").append(this.sessionID < 0 ? "x" : String.valueOf(this.sessionID));
        b.append(":").append(this.consumerID < 0 ? "x" : String.valueOf(this.consumerID));
        b.append(":").append(this.producerID < 0 ? "x" : String.valueOf(this.producerID));
        b.append("::").append(this.isNotifyMessage() ? "x" : (this.isFlagSet(this.metaInfo, 2) ? "Q" : "A") + this.observerID);
        return b.toString();
    }

    public String dumpString() {
        StringBuffer buf = new StringBuffer("MetaHeader[");
        buf.append("brokerID=").append(this.brokerID);
        buf.append(",entryID=").append(this.entryID);
        buf.append(",connectionID=").append(this.connectionID);
        buf.append(",sessionID=").append(this.sessionID);
        buf.append(",consumerID=").append(this.consumerID);
        buf.append(",producerID=").append(this.producerID);
        return buf.append("]").toString();
    }

    private boolean isFlagSet(int bitSet, int flag) {
        return (bitSet & flag) != 0;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(int length) {
        this.totalLength = length;
    }

    private void writeMetaInfo(DataOutput out) throws IOException {
        if (this.isFlagSet(this.metaInfo, 64)) {
            out.writeShort(this.partialID);
            out.writeInt(this.partialSeq);
        }
        if (this.isFlagSet(this.metaInfo, 32)) {
            out.writeShort(this.groupID);
            out.writeInt(this.groupSeq);
        }
        if (this.isFlagSet(this.metaInfo, 1)) {
            out.writeInt(this.observerID);
        }
    }

    private void readMetaInfo(DataInput in) throws IOException {
        if (this.isFlagSet(this.metaInfo, 64)) {
            this.partialID = in.readShort();
            this.partialSeq = in.readInt();
        }
        if (this.isFlagSet(this.metaInfo, 32)) {
            this.groupID = in.readShort();
            this.groupSeq = in.readInt();
        }
        if (this.isFlagSet(this.metaInfo, 1)) {
            this.observerID = in.readInt();
        }
    }

    private void setMetaFlag(int flag, boolean set) {
        this.metaInfo = set ? (this.metaInfo |= flag) : (this.metaInfo &= ~flag);
    }

    public boolean isNotifyMessage() {
        return !this.isFlagSet(this.metaInfo, 1);
    }

    public void setObserved(boolean observe) {
        this.setMetaFlag(1, observe);
    }

    public boolean isRequestMessage() {
        return this.isFlagSet(this.metaInfo, 1) && this.isFlagSet(this.metaInfo, 2);
    }

    public boolean isReplyMessage() {
        return this.isFlagSet(this.metaInfo, 1) && !this.isFlagSet(this.metaInfo, 2);
    }

    public void setRequestFlag(boolean request) {
        this.setMetaFlag(2, request);
    }

    public boolean isRouting() {
        return this.isClientRouting() || this.isServerRouting();
    }

    public boolean isServerRouting() {
        return this.isFlagSet(this.metaInfo, 4);
    }

    public void setServerRouting(boolean flag) {
        this.setMetaFlag(4, flag);
    }

    public boolean isClientRouting() {
        return this.isFlagSet(this.metaInfo, 8);
    }

    public void setClientRouting(boolean flag) {
        this.setMetaFlag(8, flag);
    }

    public boolean isAgency() {
        return this.isFlagSet(this.metaInfo, 16);
    }

    public void setAgency() {
        this.setMetaFlag(16, true);
    }

    public void setGroup(boolean group) {
        this.setMetaFlag(32, group);
    }

    public void setPartial(boolean partial) {
        this.setMetaFlag(64, partial);
    }

    public boolean isAdminMessage() {
        return this.isFlagSet(this.metaInfo, 128);
    }

    public void setAdmin(boolean admin) {
        this.setMetaFlag(128, admin);
    }

    public boolean isRedelivered() {
        return this.isFlagSet(this.metaInfo, 256);
    }

    public void setRedelivered(boolean redelivered) {
        this.setMetaFlag(256, redelivered);
    }

    public boolean isTransformed() {
        return this.isFlagSet(this.metaInfo, 512);
    }

    public void setTransformed(boolean transformed) {
        this.setMetaFlag(512, transformed);
    }

    public boolean isPartialMessage() {
        return this.getPartialID() != 0;
    }

    public boolean isEOF() {
        return !this.isPartialMessage() || this.isPartialEOF();
    }

    public short getPartialID() {
        return this.partialID;
    }

    public void setPartialID(short partialID) {
        this.partialID = partialID;
        this.setPartial(partialID != 0);
    }

    public int getPartialSequence() {
        return this.partialSeq & Integer.MAX_VALUE;
    }

    public void setPartialSequence(int sequence) {
        this.partialSeq = sequence;
    }

    public boolean isPartialEOF() {
        return (this.partialSeq & Integer.MIN_VALUE) != 0;
    }

    public void setPartialEOF() {
        this.partialSeq |= Integer.MIN_VALUE;
    }

    public short getGroupID() {
        return this.groupID;
    }

    public void setGroupID(short groupID) {
        this.groupID = groupID;
        this.setPartial(groupID != 0);
    }

    public boolean isGroupedMessage() {
        return this.getGroupID() != 0;
    }

    public int getGroupSequence() {
        return this.groupSeq & Integer.MAX_VALUE;
    }

    public void setGroupSequence(int groupSeq) {
        this.groupSeq = groupSeq;
    }

    public boolean isGroupEOF() {
        return (this.groupSeq & Integer.MIN_VALUE) != 0;
    }

    public void setGroupEOF() {
        this.groupSeq |= Integer.MIN_VALUE;
    }

    public int getObserverID() {
        return this.observerID;
    }

    public void setObserverID(int id) {
        this.observerID = id;
        this.setObserved(true);
    }

    private void writeTargetInfo(DataOutput out) throws IOException {
        byte target;
        if (this.isSetBroker()) {
            out.writeShort(this.brokerID);
        }
        if (this.isFlagSet(target = this.getLocalTargetID(), 2)) {
            out.writeLong(this.entryID);
        }
        if (this.isFlagSet(target, 4)) {
            out.writeInt(this.connectionID);
        }
        if (this.isFlagSet(target, 8)) {
            out.writeInt(this.sessionID);
        }
        if (this.isFlagSet(target, 16)) {
            out.writeInt(this.consumerID);
        }
        if (this.isFlagSet(target, 32)) {
            out.writeInt(this.producerID);
        }
    }

    private void readTargetInfo(DataInput in) throws IOException {
        byte target;
        if (this.isSetBroker()) {
            this.brokerID = in.readShort();
        }
        if (this.isFlagSet(target = this.getLocalTargetID(), 2)) {
            this.entryID = in.readLong();
        }
        if (this.isFlagSet(target, 4)) {
            this.connectionID = in.readInt();
        }
        if (this.isFlagSet(target, 8)) {
            this.sessionID = in.readInt();
        }
        if (this.isFlagSet(target, 16)) {
            this.consumerID = in.readInt();
        }
        if (this.isFlagSet(target, 32)) {
            this.producerID = in.readInt();
        }
    }

    private void setTargetFlag(int flag, boolean set) {
        this.targetID = set ? (byte)(this.targetID | flag) : (byte)(this.targetID & ~flag);
    }

    public void clear() {
        this.entryID = -1L;
        this.sessionID = -1;
        this.consumerID = -1;
        this.producerID = -1;
        this.connectionID = -1;
    }

    public boolean isRecovered() {
        return (this.targetID & 1) == 0;
    }

    public void setRecovered(boolean recovered) {
        this.setTargetFlag(1, !recovered);
    }

    public byte getTargetID() {
        if (this.isSetBroker()) {
            return 64;
        }
        return this.targetID;
    }

    public void setTargetID(byte targetID) {
        if (this.isSetBroker()) {
            targetID = (byte)(targetID | 0x40);
        }
        this.targetID = targetID;
    }

    public boolean isSetBroker() {
        return (this.targetID & 0x40) != 0;
    }

    public byte getLocalTargetID() {
        return (byte)(this.targetID & 0xFFFFFFBF);
    }

    public short getBrokerID() {
        return this.brokerID;
    }

    public void setBrokerID(short brokerID) {
        this.brokerID = brokerID;
        this.setTargetFlag(64, true);
    }

    public long getEntryID() {
        return this.entryID;
    }

    public void setEntryID(long id) {
        this.entryID = id;
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public void setConnectionID(int connectionID) {
        this.connectionID = connectionID;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(int id) {
        this.sessionID = id;
    }

    public int getConsumerID() {
        return this.consumerID;
    }

    public void setConsumerID(int id) {
        this.consumerID = id;
    }

    public int getProducerID() {
        return this.producerID;
    }

    public void setProducerID(int producerID) {
        this.producerID = producerID;
    }

    public byte getMessageType() {
        return this.msgType;
    }

    public void setMessageType(byte type) {
        this.msgType = type;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public boolean isDelayed() {
        return this.delayed;
    }

    public void setDelayed(boolean delayed) {
        this.delayed = delayed;
    }

    public boolean isLocalConsume() {
        return this.localConsume;
    }

    public void setLocalConsume(boolean localConsume) {
        this.localConsume = localConsume;
    }
}

