/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.ProtocolUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.Serializer;
import jeus.util.message.JeusMessage_JMS;

public class ObjectMessageImpl
extends ClientMessage
implements ObjectMessage {
    private Serializable object;
    private Serializable oldObject;

    public ObjectMessageImpl() {
        super((byte)79);
    }

    public ObjectMessageImpl(MetaHeader metaHeader) {
        super(metaHeader);
    }

    public ObjectMessageImpl(Serializable object) throws JMSException {
        super((byte)79);
        this.setObject(object);
    }

    public Object clone() {
        ObjectMessageImpl message = (ObjectMessageImpl)this.getMessageClone();
        message.object = this.object;
        return message;
    }

    public void setObject(Serializable object) throws JMSException {
        this.checkOutputStream();
        if (object == null) {
            this.object = null;
            return;
        }
        try {
            Serializer serial = new Serializer();
            byte[] byteObject = serial.serialize((Object)object);
            this.object = this.deserializeInnerData(byteObject);
        }
        catch (Exception ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4230), ex);
        }
    }

    private Serializable deserializeInnerData(byte[] byteObject) throws JMSException {
        try {
            Serializer serial = new Serializer();
            return (Serializable)serial.deserialize(byteObject);
        }
        catch (Exception ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4230), ex);
        }
    }

    public Serializable getObject() throws JMSException {
        return this.object;
    }

    public void clearBody() {
        if (this.oldObject == null) {
            this.oldObject = this.object;
        }
        this.object = null;
        super.clearBody();
    }

    protected void recoverBody() {
        if (this.oldObject != null) {
            this.object = this.oldObject;
            this.oldObject = null;
        }
    }

    public void marshal(DataOutput out) throws IOException {
        ProtocolUtil.writeObject(this.object, out);
    }

    public void unmarshal(DataInput in) throws IOException {
        this.object = (Serializable)ProtocolUtil.readObject(in);
    }

    public String toString() {
        return "ObjectMessage " + super.toString();
    }
}

