/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageHeader;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MessageProperty;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JMS;

public abstract class UserMessage
extends MessageContainer
implements Message {
    protected MessageID messageID;
    protected MessageHeader msgHeader;
    protected MessageProperty properties;
    private MessageProperty originalPropertyTable;
    private MessageHeader originalHeader;
    protected boolean compress;
    protected int redeliveryLimit = JMSServerEntry.DEFAULT_REDELIVERY_LIMIT;
    protected int deliveryCount;
    private transient boolean userCompaction;
    private transient boolean isReadOnlyProperty;
    private transient boolean isReadOnlyBody;

    public UserMessage(byte type) {
        super(new MetaHeader(type));
        this.msgHeader = new MessageHeader();
    }

    public UserMessage(MetaHeader metaHeader) {
        this(metaHeader, false);
    }

    protected UserMessage(MetaHeader metaHeader, boolean createMsgHeader) {
        super(metaHeader);
        if (createMsgHeader) {
            this.msgHeader = new MessageHeader();
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        this.writeMessage(out);
    }

    public void readExternal(DataInput in) throws IOException {
        this.readMessage(in);
    }

    public void writeMessage(DataOutput out) throws IOException {
        this.writeHeader(out);
        this.writeBody(out);
    }

    public void readMessage(DataInput in) throws IOException {
        this.readHeader(in);
        this.readBody(in);
    }

    public void writeHeader(DataOutput out) throws IOException {
        this.messageID.writeExternal(out);
        this.msgHeader.writeExternal(out);
        if (this.properties == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            this.properties.writeExternal(out);
        }
        out.writeInt(this.redeliveryLimit);
    }

    public void readHeader(DataInput in) throws IOException {
        this.messageID = new MessageID(in);
        this.msgHeader = new MessageHeader(in);
        if (in.readInt() == 0) {
            this.properties = null;
        } else {
            this.properties = new MessageProperty();
            this.properties.readExternal(in);
        }
        this.redeliveryLimit = in.readInt();
    }

    public void writeBody(DataOutput out) throws IOException {
    }

    public void readBody(DataInput in) throws IOException {
    }

    void checkOutputStream() throws MessageNotWriteableException {
        if (this.isReadOnlyBody()) {
            throw new MessageNotWriteableException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4225));
        }
    }

    public void recoverContents() {
        this.msgHeader = this.originalHeader;
        if (this.originalPropertyTable != null) {
            this.properties = this.originalPropertyTable;
            this.originalPropertyTable = null;
        }
        this.recoverBody();
        this.setJMSRedelivered(true);
    }

    protected void recoverBody() {
    }

    public String toString() {
        StringBuffer b = new StringBuffer("{N:{").append(this.messageID == null ? "--}" : this.messageID + "}");
        b.append(super.toString());
        if (this.msgHeader != null) {
            b.append("->").append(this.msgHeader.getDestination());
            Destination reply = this.msgHeader.getReplyTo();
            if (reply != null) {
                b.append("->").append(reply);
            }
        }
        b.append('}');
        return b.toString();
    }

    public String dumpString() {
        StringBuffer buf = new StringBuffer(super.dumpString());
        buf.append(" + UserMessage[messageID=");
        buf.append(this.messageID);
        buf.append(",msgHeader=");
        buf.append(this.msgHeader);
        buf.append(",properties=");
        buf.append(this.properties);
        buf.append("]");
        return buf.toString();
    }

    public boolean getJMSRedelivered() {
        return this.metaHeader.isRedelivered();
    }

    public void setJMSRedelivered(boolean redelivered) {
        this.metaHeader.setRedelivered(redelivered);
    }

    public void clearMetaHeader() {
        this.metaHeader.clear();
    }

    public MessageID getMessageID() {
        return this.messageID;
    }

    public void setMessageID(MessageID messageID) {
        this.messageID = messageID;
    }

    public String getJMSMessageID() {
        return this.messageID == null ? null : this.messageID.getJMSMessageID();
    }

    public boolean isTransacted() {
        return this.messageID.isTransacted();
    }

    public void setTransacted(boolean transacted) {
        this.messageID.setTransacted(transacted);
    }

    public boolean isPersisted() {
        return this.messageID.isPersisted();
    }

    protected void setPersisted(boolean persistent) {
        this.messageID.setPersisted(persistent);
    }

    public MessageHeader getHeader() {
        return this.msgHeader;
    }

    public boolean isPersistent() {
        return this.msgHeader.getDeliveryMode() == 2;
    }

    public DestinationIdentity getDestination() {
        return this.msgHeader.getDestination();
    }

    public boolean isExpire() {
        return this.msgHeader.isExpire();
    }

    public long getExpiration() {
        return this.msgHeader.getExpiration();
    }

    public boolean isScheduled() {
        return this.msgHeader.isScheduled();
    }

    public long getScheduledTime() {
        return this.msgHeader.getScheduledTime();
    }

    public void setScheduledTime(long schedule) {
        this.msgHeader.setScheduledTime(schedule);
    }

    public int getMetaInfo() {
        return this.msgHeader.getMetaInfo();
    }

    public void setMetaInfo(int metaInfo) {
        this.msgHeader.setMetaInfo(metaInfo);
    }

    public void setJMSMessageID(String id) {
        this.msgHeader.setJMSMessageID(id);
    }

    public long getJMSTimestamp() {
        return this.msgHeader.getJMSTimestamp();
    }

    public void setJMSTimestamp(long timestamp) {
        this.msgHeader.setJMSTimestamp(timestamp);
    }

    public String getJMSCorrelationID() {
        return this.msgHeader.getJMSCorrelationID();
    }

    public void setJMSCorrelationID(String correlationID) {
        this.msgHeader.setJMSCorrelationID(correlationID);
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.msgHeader.getJMSCorrelationIDAsBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.msgHeader.setJMSCorrelationIDAsBytes(correlationID);
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.msgHeader.getJMSReplyTo();
    }

    public void setJMSReplyTo(Destination replyTo) {
        this.msgHeader.setJMSReplyTo(replyTo);
    }

    public Destination getJMSDestination() throws JMSException {
        return this.msgHeader.getJMSDestination();
    }

    public void setJMSDestination(Destination destination) {
        this.msgHeader.setJMSDestination(destination);
    }

    public int getJMSDeliveryMode() {
        return this.msgHeader.getJMSDeliveryMode();
    }

    public void setJMSDeliveryMode(int deliveryMode) {
        this.msgHeader.setJMSDeliveryMode(deliveryMode);
    }

    public String getJMSType() {
        return this.msgHeader.getJMSType();
    }

    public void setJMSType(String type) {
        this.msgHeader.setJMSType(type);
    }

    public long getJMSExpiration() {
        return this.msgHeader.getJMSExpiration();
    }

    public void setJMSExpiration(long expiration) {
        this.msgHeader.setJMSExpiration(expiration);
    }

    public int getJMSPriority() {
        return this.msgHeader.getJMSPriority();
    }

    public void setJMSPriority(int priority) {
        this.msgHeader.setJMSPriority(priority);
    }

    public MessageProperty getProperties() {
        return this.properties;
    }

    public boolean hasUserProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean propertyExists(String name) {
        return this.properties != null && this.properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        this.checkPropertyTable();
        return this.properties.getBooleanProperty(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        this.checkPropertyTable();
        return this.properties.getByteProperty(name);
    }

    public short getShortProperty(String name) throws JMSException {
        this.checkPropertyTable();
        return this.properties.getShortProperty(name);
    }

    public int getIntProperty(String name) throws JMSException {
        this.checkPropertyTable();
        return this.properties.getIntProperty(name);
    }

    public long getLongProperty(String name) throws JMSException {
        this.checkPropertyTable();
        return this.properties.getLongProperty(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        this.checkPropertyTable();
        return this.properties.getFloatProperty(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        this.checkPropertyTable();
        return this.properties.getDoubleProperty(name);
    }

    public String getStringProperty(String name) throws JMSException {
        this.checkPropertyTable();
        return this.properties.getStringProperty(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        this.checkPropertyTable();
        return this.properties.getObjectProperty(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        this.checkPropertyTable();
        return this.properties.getPropertyNames();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkReadOnlyProperty();
        if (this.checkJeusProperty(name, value)) {
            return;
        }
        this.checkPropertyTable();
        this.properties.setBooleanProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkReadOnlyProperty();
        this.checkPropertyTable();
        this.properties.setByteProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.checkReadOnlyProperty();
        this.checkPropertyTable();
        this.properties.setShortProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.checkReadOnlyProperty();
        if (this.checkJeusProperty(name, value)) {
            return;
        }
        this.checkPropertyTable();
        this.properties.setIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.checkReadOnlyProperty();
        if (this.checkJeusProperty(name, value)) {
            return;
        }
        this.checkPropertyTable();
        this.properties.setLongProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkReadOnlyProperty();
        this.checkPropertyTable();
        this.properties.setFloatProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkReadOnlyProperty();
        this.checkPropertyTable();
        this.properties.setDoubleProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkReadOnlyProperty();
        this.checkPropertyTable();
        this.properties.setStringProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkReadOnlyProperty();
        this.checkPropertyTable();
        this.properties.setObjectProperty(name, value);
    }

    public void setProperties(Map map) throws JMSException {
        this.properties = new MessageProperty(map);
    }

    private synchronized void checkPropertyTable() {
        if (this.properties == null) {
            this.properties = new MessageProperty();
        }
    }

    public void clearProperties() {
        if (this.originalPropertyTable == null) {
            this.originalPropertyTable = this.properties;
            this.properties = new MessageProperty();
        } else {
            this.properties.clear();
        }
        this.setReadOnlyProperty(false);
    }

    private void checkReadOnlyProperty() throws MessageNotWriteableException {
        if (this.isReadOnlyProperty) {
            throw new MessageNotWriteableException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4225));
        }
    }

    private boolean checkJeusProperty(String key, boolean value) {
        if (key.equalsIgnoreCase("JMS_JEUS_Compaction")) {
            this.setCompress(value);
            this.userCompaction = true;
        }
        return key.startsWith("JMS_JEUS_");
    }

    private boolean checkJeusProperty(String key, int value) {
        if (key.equalsIgnoreCase("JMS_JEUS_RedeliveryLimit")) {
            this.setRedeliveryLimit(value);
        }
        return key.startsWith("JMS_JEUS_");
    }

    private boolean checkJeusProperty(String key, long value) {
        if (key.equalsIgnoreCase("JMS_JEUS_Schedule")) {
            this.setScheduledTime(value);
        }
        return key.startsWith("JMS_JEUS_");
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean userCompaction() {
        return this.userCompaction;
    }

    public void acknowledge() throws JMSException {
    }

    public void clearBody() {
        this.isReadOnlyBody = false;
    }

    protected void checkReadMode() throws MessageNotReadableException {
        if (!this.isReadOnlyBody) {
            throw (MessageNotReadableException)JMSExceptionFactory.createJMSException(JeusMessage_JMS._3131, null, 5);
        }
    }

    protected void checkWriteMode() throws MessageNotWriteableException {
        if (this.isReadOnlyBody) {
            throw (MessageNotWriteableException)JMSExceptionFactory.createJMSException(JeusMessage_JMS._3132, null, 6);
        }
    }

    public int getRedeliveryLimit() {
        return this.redeliveryLimit;
    }

    public void setRedeliveryLimit(int redeliveryLimit) {
        this.redeliveryLimit = redeliveryLimit;
    }

    boolean isReadOnlyBody() {
        return this.isReadOnlyBody;
    }

    public void setReadOnlyBody(boolean value) {
        this.isReadOnlyBody = value;
    }

    public void setReadOnlyProperty(boolean value) {
        this.isReadOnlyProperty = value;
    }

    public void backupContents() {
        this.originalHeader = this.msgHeader;
        this.msgHeader = this.msgHeader.getClone();
    }

    public void increaseDeliveryCount() {
        if (++this.deliveryCount > 1) {
            this.setJMSRedelivered(true);
        }
    }

    public void decreaseDeliveryCount() {
        if (--this.deliveryCount < 1) {
            this.setJMSRedelivered(false);
        }
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }
}

