/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.jms.JMSException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.ProtocolUtil;

public class AdminMessage
extends MessageContainer {
    private static final byte NO_EXIST_EXCEPTION = 0;
    private static final byte EXIST_EXCEPTION = 1;
    private byte opcode;
    private long flag;
    private JMSException ex;

    protected AdminMessage() {
        this.setDirect(true);
    }

    public AdminMessage(byte opcode) {
        this.opcode = opcode;
        this.metaHeader.setAdmin(true);
    }

    public AdminMessage(MetaHeader metaHeader, byte opcode) {
        super(metaHeader);
        this.opcode = opcode;
        metaHeader.setAdmin(true);
    }

    public AdminMessage(MetaHeader metaHeader) {
        super(metaHeader);
        this.opcode = 1;
        metaHeader.setAdmin(true);
    }

    public boolean isPublic() {
        return this.opcode < 0;
    }

    public void readExternal(DataInput in) throws IOException {
        this.opcode = in.readByte();
        this.readBody(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.opcode);
        this.writeBody(out);
    }

    public void readBody(DataInput in) throws IOException {
        this.flag = in.readLong();
        if (in.readByte() != 0) {
            this.ex = (JMSException)((Object)ProtocolUtil.readObject(in));
        }
    }

    public void writeBody(DataOutput out) throws IOException {
        out.writeLong(this.flag);
        if (this.ex != null) {
            out.writeByte(1);
            this.ex.setLinkedException(null);
            ProtocolUtil.writeObject((Object)this.ex, out);
        } else {
            out.writeByte(0);
        }
    }

    public byte getOperationID() {
        return this.opcode;
    }

    public void setOperationID(byte opcode) {
        this.opcode = opcode;
    }

    public void setException(JMSException ex) {
        this.ex = ex;
    }

    public JMSException getException() {
        return this.ex;
    }

    public byte getByteFlag() {
        return (byte)this.flag;
    }

    public void setByteFlag(byte flag) {
        this.flag |= (long)flag;
    }

    public boolean getBooleanFlag() {
        return (this.flag & Long.MIN_VALUE) != 0L;
    }

    public void setBooleanFlag(boolean flag) {
        this.flag = flag ? (this.flag |= Long.MIN_VALUE) : (this.flag &= Long.MAX_VALUE);
    }

    public int getIntegerFlag() {
        return (int)this.flag;
    }

    public void setIntegerFlag(int flag) {
        this.flag |= (long)flag;
    }

    public long getLongFlag() {
        return this.flag & Long.MAX_VALUE;
    }

    public void setLongFlag(long flag) {
        this.flag |= flag & Long.MAX_VALUE;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("{A:");
        b.append(AdminMessage.getAdminMessageName(this.opcode)).append(':');
        b.append(this.getBooleanFlag() ? "T" : "F").append(this.getIntegerFlag()).append(':');
        if (this.ex != null) {
            b.append(this.ex.getMessage());
            b.append(':');
        }
        b.append(super.toString());
        b.append('}');
        return b.toString();
    }

    public static String getAdminMessageName(byte switchID) {
        switch (switchID) {
            case 1: {
                return "ADMIN_MESSAGE";
            }
            case 32: {
                return "SYNC_MESSAGE_REQUEST";
            }
            case 33: {
                return "ASYNC_MESSAGE_REQUEST";
            }
            case 34: {
                return "MESSAGE_SUSPEND";
            }
            case 35: {
                return "MESSAGE_RESUME";
            }
            case 48: 
            case 64: {
                return "MESSAGE_RETURN";
            }
            case 49: 
            case 65: {
                return "MESSAGE_RECOVER";
            }
            case 50: 
            case 66: {
                return "MESSAGE_ACK";
            }
            case 51: 
            case 67: {
                return "MESSAGE_NACK";
            }
            case 52: 
            case 68: {
                return "MESSAGE_POISONED";
            }
            case 8: {
                return "CREATE_CONNECTION";
            }
            case 17: {
                return "CREATE_DESTINATION";
            }
            case 18: {
                return "CREATE_DESTINATION_REMOTE";
            }
            case 26: {
                return "SUSPEND_CONSUMERS";
            }
            case 6: {
                return "CLOSE_FACILITY";
            }
            case 23: {
                return "SET_CLIENTID";
            }
            case 4: {
                return "START_FACILITY";
            }
            case 24: {
                return "REQ_CONSUMER_COUNT";
            }
            case 25: {
                return "REQ_DELIVERY_COUNT";
            }
            case 5: {
                return "STOP_FACILITY";
            }
            case 9: {
                return "CREATE_SESSION";
            }
            case 19: {
                return "ROUTING_INFO";
            }
            case 10: {
                return "CREATE_PRODUCER";
            }
            case 11: {
                return "CREATE_CONSUMER";
            }
            case 12: {
                return "CREATE_DURABLE_CONSUMER";
            }
            case 21: {
                return "CHECK_DESTINATION";
            }
            case 22: {
                return "BROWSE_QUEUE";
            }
            case 7: {
                return "UNSUBSCRIBE";
            }
            case 20: {
                return "CALLBACK_ADDRESS";
            }
            case 111: {
                return "SHARED_TRANSACTION_CONTEXT";
            }
            case 80: {
                return "LOCAL_TRANSACTION_BEGIN";
            }
            case 81: {
                return "LOCAL_TRANSACTION_COMMIT";
            }
            case 82: {
                return "LOCAL_TRANSACTION_ROLLBACK";
            }
            case 97: {
                return "GLOBAL_TRANSACTION_END";
            }
            case 96: {
                return "GLOBAL_TRANSACTION_START";
            }
            case 98: {
                return "GLOBAL_TRANSACTION_PREPARE";
            }
            case 99: {
                return "GLOBAL_TRANSACTION_COMMIT";
            }
            case 100: {
                return "GLOBAL_TRANSACTION_ROLLBACK";
            }
            case 102: {
                return "GLOBAL_TRANSACTION_RECOVER";
            }
            case 101: {
                return "GLOBAL_TRANSACTION_FORGET";
            }
            case 112: {
                return "REGISTER_CALLBACK";
            }
            case 13: {
                return "CREATE_CLIENT_ENTRY";
            }
            case 14: {
                return "CREATE_SERVER_ENTRY";
            }
            case 15: {
                return "CREATE_ENTRY_DENIED";
            }
            case 16: {
                return "CREATE_ENTRY_ACK";
            }
            case -1: {
                return "GET_MESSAGE_LIFECYCLE";
            }
            case -2: {
                return "CLEAN_UP_QUEUE";
            }
            case -3: {
                return "CLEAN_UP_DURABLE_SUBSCRIBER";
            }
            case -4: {
                return "GET_DURABLE_MESSAGE_LIFECYCLE";
            }
        }
        return "INVALID[0x" + Integer.toHexString(switchID & 0xFF) + "]";
    }
}

