/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jeus.jms.client.message.ClientMessageFactory;
import jeus.jms.common.destination.JeusQueue;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageFactory;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.ProtocolUtil;
import jeus.nio.ByteBufferWrapper;
import jeus.util.ByteArray;

public class BrowseQueueMessage
extends AdminMessage {
    private String queueName;
    private String selector;
    private List messages;

    public BrowseQueueMessage() {
        super((byte)22);
        this.setTargetID((byte)15);
    }

    public BrowseQueueMessage(JeusQueue queue, String selector) {
        super((byte)22);
        this.selector = selector;
        this.queueName = queue.getLocalName();
        this.setTargetID((byte)15);
    }

    public BrowseQueueMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)22);
    }

    public String getSelector() {
        return this.selector;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setMessages(List message) {
        this.messages = message;
    }

    public List getMessages() {
        return this.messages;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.queueName = ProtocolUtil.readString(in);
        this.selector = ProtocolUtil.readString(in);
        this.messages = BrowseQueueMessage.readMessageImplList(in);
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.queueName, out);
        ProtocolUtil.writeString(this.selector, out);
        BrowseQueueMessage.writeMessageImplList(this.messages, out);
    }

    public static void writeMessageImplList(List value, DataOutput out) throws IOException {
        if (value == null) {
            out.writeInt(0);
        } else {
            out.writeInt(value.size());
            for (ClientMessage message : value) {
                ByteBufferWrapper buffer = MessageFactory.chunkedSerialize(message);
                ByteArray array = buffer.flip().array();
                out.write(array.getArray(), array.getOffset(), array.getLength());
            }
        }
    }

    public static List readMessageImplList(DataInput in) throws IOException {
        int totalLen = in.readInt();
        ArrayList<ClientMessage> objReturn = new ArrayList<ClientMessage>(totalLen);
        for (int i = 0; i < totalLen; ++i) {
            MetaHeader metaHeader = new MetaHeader();
            metaHeader.readExternal(in);
            ClientMessage clMsg = ClientMessageFactory.createUserMessage(metaHeader, in);
            objReturn.add(clMsg);
        }
        return objReturn;
    }

    public String toString() {
        return super.toString() + " {" + this.messages + "}";
    }
}

