/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public class CreateEntryMessage
extends AdminMessage
implements Externalizable {
    private String brokerName;
    private long requestID;
    private boolean xaRecovery;

    public CreateEntryMessage() {
    }

    public CreateEntryMessage(MetaHeader metaHeader, byte opcode) {
        super(metaHeader, opcode);
    }

    public CreateEntryMessage(byte opcode, String broker, long request) {
        this(opcode, broker, request, false);
    }

    public CreateEntryMessage(byte opcode, String broker, long request, boolean xaRecovery) {
        super(opcode);
        this.brokerName = broker;
        this.requestID = request;
        this.xaRecovery = xaRecovery;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public boolean isXaRecovery() {
        return this.xaRecovery;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.brokerName = ProtocolUtil.readString(in);
        this.requestID = in.readLong();
        this.xaRecovery = in.readBoolean();
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.brokerName, out);
        out.writeLong(this.requestID);
        out.writeBoolean(this.xaRecovery);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.metaHeader.readExternal(in);
        this.readExternal((DataInput)in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.metaHeader.writeExternal(out);
        this.writeExternal((DataOutput)out);
    }

    public String toString() {
        return super.toString() + "{" + this.brokerName + ":" + this.requestID + ":" + this.xaRecovery + "}";
    }
}

