/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.JMSXid;

public class GlobalTransactionMessage
extends AdminMessage {
    private JMSXid xid;
    private long timeout;
    private boolean remote;

    public GlobalTransactionMessage(byte opcode, JMSXid xid, long timeout) {
        super(opcode);
        this.xid = xid;
        this.timeout = timeout;
    }

    public GlobalTransactionMessage(MetaHeader metaHeader, byte opcode) {
        super(metaHeader, opcode);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public JMSXid getXid() {
        return this.xid;
    }

    public void setXid(JMSXid xid) {
        this.xid = xid;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.xid = new JMSXid(in);
        this.timeout = in.readLong();
        this.remote = true;
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        this.xid.writeExternal(out);
        out.writeLong(this.timeout);
    }

    public boolean isXAExecutable() {
        switch (this.getOperationID()) {
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",{");
        b.append("timeout=").append(this.timeout).append(",");
        b.append(this.xid);
        b.append("}");
        return b.toString();
    }
}

