/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

public final class BoundedInteger {
    private final boolean incrementor;
    private final int min;
    private final int max;
    private int value;

    public static BoundedInteger getIncrementor() {
        return new BoundedInteger(1, Integer.MAX_VALUE, true);
    }

    public static BoundedInteger getDecrementor() {
        return new BoundedInteger(Integer.MIN_VALUE, -1, false);
    }

    public BoundedInteger(int min, int max, boolean incrementor) {
        this.min = min;
        this.max = max;
        this.incrementor = incrementor;
        this.value = 0;
    }

    public synchronized int get() {
        return this.value;
    }

    public synchronized void set(int value) {
        this.value = value;
    }

    public synchronized int getNextValue() {
        return this.incrementor ? this.increment() : this.decrement();
    }

    private int increment() {
        this.value = this.value == this.max ? this.min : this.value + 1;
        return this.value;
    }

    private int decrement() {
        this.value = this.value == this.min ? this.max : this.value - 1;
        return this.value;
    }
}

