/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import jeus.jms.common.util.ProtocolUtil;
import jeus.nio.ByteBufferWrapper;

public abstract class BufferInputStream
extends InputStream
implements DataInput {
    protected ByteBufferWrapper buffer;

    public BufferInputStream(ByteBufferWrapper buffer) {
        this.buffer = buffer;
    }

    public BufferInputStream(int initial) {
        this.buffer = ByteBufferWrapper.allocate(initial).limit(0);
    }

    public ByteBufferWrapper buffer() {
        return this.buffer;
    }

    public int available() {
        return this.buffer.remaining();
    }

    public int read() throws IOException {
        this.reserve(1);
        return this.buffer.get();
    }

    public byte readByte() throws IOException {
        this.reserve(1);
        return this.buffer.get();
    }

    public char readChar() throws IOException {
        this.reserve(2);
        return this.buffer.getChar();
    }

    public double readDouble() throws IOException {
        this.reserve(8);
        return this.buffer.getDouble();
    }

    public float readFloat() throws IOException {
        this.reserve(4);
        return this.buffer.getFloat();
    }

    public int readInt() throws IOException {
        this.reserve(4);
        return this.buffer.getInt();
    }

    public int readUnsignedByte() throws IOException {
        this.reserve(1);
        return this.buffer.get();
    }

    public int readUnsignedShort() throws IOException {
        this.reserve(2);
        return this.buffer.getShort();
    }

    public long readLong() throws IOException {
        this.reserve(8);
        return this.buffer.getLong();
    }

    public short readShort() throws IOException {
        this.reserve(2);
        return this.buffer.getShort();
    }

    public boolean readBoolean() throws IOException {
        this.reserve(1);
        return this.buffer.get() != 0;
    }

    public int skipBytes(int n) throws IOException {
        this.reserve(n);
        this.buffer.position(this.buffer.position() + n);
        return n;
    }

    public void readFully(byte[] b) throws IOException {
        this.reserve(b.length);
        this.buffer.get(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.reserve(len);
        this.buffer.get(b, off, len);
    }

    public String readLine() throws IOException {
        throw new IOException("not supported");
    }

    public String readUTF() throws IOException {
        return ProtocolUtil.readUTF(this);
    }

    protected void reserveBuffer(int size) {
        int newSize = Math.max(size, this.buffer.capacity());
        ByteBufferWrapper newBuffer = this.buffer.isDirect() ? ByteBufferWrapper.allocateDirect(newSize) : ByteBufferWrapper.allocate(newSize);
        newBuffer.put(this.buffer.flip()).limit(size);
        ByteBufferWrapper.free(this.buffer);
        this.buffer = null;
        this.buffer = newBuffer;
    }

    protected abstract void reserve(int var1) throws IOException;
}

