/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import javax.jms.JMSException;

public class DestinationCreationParam {
    public static final char OPTIONS_MARKER = '?';
    public static final char BROKER_MARKER = '@';
    private final boolean isQueue;
    private final String brokerName;
    private final String destinationName;
    private boolean creationCommand;
    private String exportName;
    private Boolean multipleReceiver;

    public DestinationCreationParam(boolean isQueue, String paramString) throws JMSException {
        String locationString;
        this.isQueue = isQueue;
        if (paramString == null) {
            throw new JMSException("invalid command " + paramString);
        }
        int optionsMarkerIndex = paramString.indexOf(63);
        if (optionsMarkerIndex != -1) {
            this.creationCommand = true;
            try {
                String optionString = paramString.substring(optionsMarkerIndex + 1);
                if (optionString.length() > 0) {
                    this.parseOptions(optionString);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new JMSException("invalid command " + paramString);
            }
            locationString = paramString.substring(0, optionsMarkerIndex);
        } else {
            locationString = paramString;
        }
        int brokerMarkerIndex = locationString.indexOf(64);
        if (brokerMarkerIndex != -1) {
            this.destinationName = locationString.substring(0, brokerMarkerIndex);
            this.brokerName = locationString.substring(brokerMarkerIndex + 1);
        } else {
            this.destinationName = locationString;
            this.brokerName = null;
        }
        if (this.destinationName == null || this.destinationName.length() == 0) {
            throw new JMSException("invalid command " + paramString);
        }
        if (this.brokerName != null && this.brokerName.length() == 0) {
            throw new JMSException("invalid command " + paramString);
        }
    }

    private void parseOptions(String optionString) {
        String[] options = optionString.split("&");
        for (int i = 0; i < options.length; ++i) {
            String[] keyAndValue = options[i].split("=");
            String key = keyAndValue[0];
            String value = keyAndValue[1];
            if (key.equals("export-name")) {
                if (this.exportName == null) {
                    this.exportName = value;
                    continue;
                }
            } else if (key.equals("multiple-receiver") && this.multipleReceiver == null && this.isQueue) {
                this.multipleReceiver = Boolean.valueOf(value);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public boolean isCreationCommand() {
        return this.creationCommand;
    }

    public String getExportName() {
        if (this.exportName == null) {
            return this.destinationName;
        }
        return this.exportName;
    }

    public boolean getMultipleReceiver() {
        if (this.multipleReceiver == null) {
            return false;
        }
        return this.multipleReceiver;
    }
}

