/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import java.io.IOException;
import jeus.jms.common.message.IntermediateReceivedMessage;

public class IndexedList {
    private IntermediateReceivedMessage[] array = new IntermediateReceivedMessage[10];
    private int fixed = -1;

    public synchronized void add(int index, IntermediateReceivedMessage message) throws IOException {
        if (this.fixed != -1 && index > this.fixed) {
            throw new IOException("invalid index");
        }
        this.assertSize(index);
        this.array[index] = message;
    }

    public synchronized void fix(int index) throws IOException {
        if (this.lastindex() > index) {
            throw new IOException("invalid index");
        }
        this.fixed = index;
    }

    public synchronized int fixedIndex() throws IOException {
        if (this.fixed < 0) {
            throw new IOException("invalid index");
        }
        return this.fixed;
    }

    public synchronized int lastindex() {
        for (int i = this.array.length - 1; i >= 0; --i) {
            if (this.array[i] == null) continue;
            return i;
        }
        return -1;
    }

    public synchronized int firstindex() {
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            return i;
        }
        return -1;
    }

    public synchronized boolean isCompleted() {
        if (this.fixed < 0) {
            return false;
        }
        for (int i = 0; i < this.fixed; ++i) {
            if (this.array[i] != null) continue;
            return false;
        }
        return true;
    }

    public IntermediateReceivedMessage[] getArray() {
        return this.array;
    }

    private void assertSize(int index) {
        if (this.array.length <= index) {
            IntermediateReceivedMessage[] newArray = new IntermediateReceivedMessage[index + 1];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
    }
}

