/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

public class Timer {
    public static final long BLOCK_TIMEOUT = 0L;
    private boolean started;
    private long prev;
    private long remain;

    public Timer() {
    }

    public Timer(long timeout) {
        this.start(timeout);
    }

    public Timer(long timeout, long delay) {
        this.start(timeout);
        this.elapsWhile(delay);
    }

    public synchronized void start(long timeout) {
        this.remain = timeout == 0L ? Integer.MAX_VALUE : timeout;
        this.prev = System.currentTimeMillis();
        this.started = true;
    }

    public synchronized void resume() {
        this.prev = System.currentTimeMillis();
    }

    public synchronized void prolong(long add) {
        this.remain += add;
    }

    public synchronized long remaining() {
        return this.remain == 0L ? -1L : this.remain;
    }

    public synchronized long elapsed() {
        long current = System.currentTimeMillis();
        this.remain -= current - this.prev;
        this.prev = current;
        return this.remaining();
    }

    public synchronized long elapsedBy() {
        long current = System.currentTimeMillis();
        long elapsed = current - this.prev;
        this.remain -= elapsed;
        this.prev = current;
        return elapsed;
    }

    public synchronized long elapsWhile(long wait) {
        long elapsed = this.elapsedBy();
        if (elapsed >= wait) {
            return this.remaining();
        }
        try {
            this.wait(wait - elapsed);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return this.elapsed();
    }

    public synchronized void cancel() {
        this.remain = -1L;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public String toString() {
        return "R" + this.remaining();
    }
}

