/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanServerConnection;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.comm.ClusterPeerInfo;
import jeus.jms.server.mbean.JMSResourceMBean;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.render.PropertyRenderer;

public class JMSClusterCommand
extends JMSCommand {
    public JMSClusterCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "cluster", "lists all clusted peers", utility, container);
    }

    public void run(PrintStream out) throws Exception {
        JMSResourceMBean jmsMbean = this.getJMSResourceMBean();
        ArrayList infos = jmsMbean.getClusterPeerInfos();
        if (infos.isEmpty()) {
            this.directLogWithSpace("There are no clustered peers.", out);
        } else {
            Iterator i = infos.iterator();
            PropertyRenderer renderer = new PropertyRenderer(this.console);
            renderer.setTitle("CLUSTERED PEERS INFORMATIONS");
            while (i.hasNext()) {
                ClusterPeerInfo info = (ClusterPeerInfo)i.next();
                renderer.addProperty("BROKER NAME", info.getBrokerName());
                renderer.addProperty("BROKER ID", "" + info.getBrokerID());
                renderer.addProperty("ADDRESS", info.getAddress());
                renderer.addProperty("PORT", "" + info.getPort());
                renderer.addProperty("ESTABLISHED", "" + info.isEstablished());
                if (!i.hasNext()) continue;
                renderer.addSeperator();
            }
            renderer.render(out);
        }
    }
}

