/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSConnectionFactoryResourceMBean;
import jeus.management.JMXUtility;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;
import jeus.util.console.render.PropertyRenderer;

public class JMSConfCommand
extends JMSCommand {
    private Argument confNameArg = new Argument("conf_name", "connection factory name");

    public JMSConfCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "conf", "prints information of the specified connection factory", utility, container);
        this.registerArgument(this.confNameArg);
    }

    public void run(PrintStream out) throws Exception {
        ObjectName[] factoryNames = JMXUtility.findJeusMBean((MBeanServerConnection)this.utility, (String)this.container, (String)"JMSConnectionFactoryResource", (String)this.confNameArg.getValue());
        if (factoryNames == null || factoryNames.length == 0) {
            out.println("No connection factory found for " + this.confNameArg.getValue());
            return;
        }
        PropertyRenderer renderer = new PropertyRenderer(this.console);
        renderer.setTitle("CONNECTION FACTORY INFORMATIONS");
        for (int i = 0; i < factoryNames.length; ++i) {
            ObjectName d = factoryNames[i];
            JMSConnectionFactoryResourceMBean mBean = (JMSConnectionFactoryResourceMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)d, JMSConnectionFactoryResourceMBean.class, (boolean)false);
            renderer.addProperty("FACTORY NAME", mBean.getFactoryName());
            renderer.addProperty("EXPORT NAME", mBean.getExportName());
            renderer.addProperty("FACTORY NAME", mBean.getFactoryType());
            renderer.addProperty("CLIENT ID", mBean.getClientID());
            renderer.addProperty("MAX THREAD", "" + mBean.getMaxSessionThread());
            renderer.addProperty("CLUSTER", "" + mBean.isCluster());
            renderer.addProperty("BROKER SELECTION POLICY", mBean.getBrokerSelectionPolicyType());
            JMSServiceChannelAddress[] addresses = mBean.getAddresses();
            for (int j = 0; j < addresses.length; ++j) {
                StringBuffer buf = new StringBuffer();
                JMSServiceChannelAddress address = addresses[j];
                buf.append("[").append(address.getBrokerName()).append(",").append(address.getBrokerID());
                buf.append(",").append(address.getServerURL()).append("] ");
                if (j == 0) {
                    renderer.addProperty("ADDRESSES", buf.toString());
                    continue;
                }
                renderer.addProperty("", buf.toString());
            }
            if (i + 1 >= factoryNames.length) continue;
            renderer.addSeperator();
        }
        renderer.render(out);
    }
}

