/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import javax.management.MBeanServerConnection;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSResourceMBean;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;
import jeus.util.console.ToggleArguments;

public class JMSCreateConfCommand
extends JMSCommand {
    private Option queueOption = new Option("q", "create queue connection factory");
    private Option topicOption = new Option("t", "create topic connection factory");
    private Option persistOption = new Option("per", "persist to JMSMain.xml");
    private Argument exportNameArg;
    private Argument confNameArg;
    private Argument maxThreadArg;
    private OptionalArgument clientIDArg;

    public JMSCreateConfCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "createconf", "create connection factory", utility, container);
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.queueOption, this.topicOption}));
        this.registerArgument((Argument)this.persistOption);
        this.confNameArg = new Argument("conf_name", "connection factory name");
        this.registerArgument(this.confNameArg);
        this.exportNameArg = new Argument("export_name", "export name for new connection factory");
        this.registerArgument(this.exportNameArg);
        this.maxThreadArg = new OptionalArgument("maxThread", "maximum thread number for the connection factory", "10");
        this.registerArgument(this.maxThreadArg);
        this.clientIDArg = new OptionalArgument("clientID", "clientID for topic connection factory");
        this.registerArgument((Argument)this.clientIDArg);
    }

    public void run(PrintStream out) throws Exception {
        JMSResourceMBean jmsMbean = this.getJMSResourceMBean();
        int _maxThreads = this.maxThreadArg.isSet() ? Integer.parseInt(this.maxThreadArg.getValue()) : 10;
        if (this.queueOption.isSet()) {
            if (this.clientIDArg.isSet()) {
                throw new IllegalArgumentException("ClientID is not allowed to set for queue connnection fatory.");
            }
            jmsMbean.addQueueConnectionFactory(this.confNameArg.getValue(), this.exportNameArg.getValue(), _maxThreads, this.persistOption.isSet());
        } else if (this.topicOption.isSet()) {
            jmsMbean.addTopicConnectionFactory(this.confNameArg.getValue(), this.exportNameArg.getValue(), _maxThreads, this.clientIDArg.getValue(), this.persistOption.isSet());
        }
    }
}

