/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import javax.management.MBeanServerConnection;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSResourceMBean;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.ToggleArguments;

public class JMSCreateDestCommand
extends JMSCommand {
    private Option queueOption = new Option("q", "create queue");
    private Option topicOption = new Option("t", "create topic");
    private Option persistOption = new Option("per", "persist to JMSMain.xml");
    private Argument destNameArg;
    private Argument exportNameArg;

    public JMSCreateDestCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "createdest", "create destination", utility, container);
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.queueOption, this.topicOption}));
        this.registerArgument((Argument)this.persistOption);
        this.destNameArg = new Argument("dest_name", "destination name");
        this.registerArgument(this.destNameArg);
        this.exportNameArg = new Argument("export_name", "export name for new destination");
        this.registerArgument(this.exportNameArg);
    }

    public void run(PrintStream out) throws Exception {
        JMSResourceMBean jmsMbean = this.getJMSResourceMBean();
        if (this.queueOption.isSet()) {
            jmsMbean.addQueueDestination(this.destNameArg.getValue(), this.exportNameArg.getValue(), null, this.persistOption.isSet());
        } else if (this.topicOption.isSet()) {
            jmsMbean.addTopicDestination(this.destNameArg.getValue(), this.exportNameArg.getValue(), null, this.persistOption.isSet());
        }
    }
}

