/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSDestinationResourceMBean;
import jeus.jms.server.mbean.JMSDurableSubscriberResourceMBean;
import jeus.jms.server.mbean.JMSQueueDestinationResourceMBean;
import jeus.jms.server.mbean.JMSTopicDestinationResourceMBean;
import jeus.management.JMXUtility;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;
import jeus.util.console.ToggleArguments;

public class JMSDestCommand
extends JMSCommand {
    private Argument destNameArg;
    private Option messageOption = new Option("m", "includes message information");
    private Option removeOption;
    private OptionalArgument selectorOrMsgIDArg;
    private Option removeAllOption;
    private Option pendingMessageOption = new Option("p", "includes pending message information");
    private Option requeueAllOption;
    private Option requeueOption;
    private Option newDeliveryOption;

    public JMSDestCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "dest", "print destination information", utility, container);
        this.removeOption = new Option("r", "remove message, only for Queue");
        this.removeAllOption = new Option("ra", "remove all messages, only for Queue");
        this.requeueAllOption = new Option("qa", "requeue all pending messages, only for Queue");
        this.requeueOption = new Option("q", "requeue the specified pending messages, only for Queue");
        this.newDeliveryOption = new Option("n", "requeue to not-delivered message, only for Queue");
        this.registerArgument((Argument)this.messageOption);
        this.registerArgument((Argument)this.pendingMessageOption);
        this.registerArgument((Argument)this.newDeliveryOption);
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.removeOption, this.removeAllOption, this.requeueOption, this.requeueAllOption}));
        this.destNameArg = new Argument("dest_name", "destination name");
        this.registerArgument(this.destNameArg);
        this.selectorOrMsgIDArg = new OptionalArgument("selector_or_msgID", "message selector for message browsing, or message ID to remove");
        this.registerArgument((Argument)this.selectorOrMsgIDArg);
    }

    public void run(PrintStream out) throws Exception {
        String destName = this.destNameArg.getValue();
        ObjectName[] destNames = JMXUtility.findJeusMBean((MBeanServerConnection)this.utility, (String)this.container, (String)"JMSDestinationResource", (String)destName);
        if (destNames == null || destNames.length == 0) {
            out.println("There is no " + destName + " destination.");
        } else {
            this.ShowDestination(destNames, out);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ShowDestination(ObjectName[] destNames, PrintStream out) throws JMSException, JeusImproperCommanderException {
        for (int i = 0; i < destNames.length; ++i) {
            JMSQueueDestinationResourceMBean queue;
            ObjectName d = destNames[i];
            JMSDestinationResourceMBean mbean = (JMSDestinationResourceMBean)JMSDestCommand.newProxyInstance(this.utility, d, JMSQueueDestinationResourceMBean.class, JMSTopicDestinationResourceMBean.class, false);
            if (this.removeOption.isSet()) {
                queue = (JMSQueueDestinationResourceMBean)mbean;
                if (!this.selectorOrMsgIDArg.isSet()) throw new JeusImproperCommanderException("message ID is required for removing message");
                queue.removeMessage(this.selectorOrMsgIDArg.getValue());
            } else if (this.removeAllOption.isSet()) {
                queue = (JMSQueueDestinationResourceMBean)mbean;
                queue.removeAllMessages();
            } else if (this.requeueOption.isSet()) {
                queue = (JMSQueueDestinationResourceMBean)mbean;
                if (!this.selectorOrMsgIDArg.isSet()) throw new JeusImproperCommanderException("message ID is required for requeueing pending message");
                queue.requeuePendingMessage(this.selectorOrMsgIDArg.getValue(), this.newDeliveryOption.isSet());
            } else if (this.requeueAllOption.isSet()) {
                queue = (JMSQueueDestinationResourceMBean)mbean;
                queue.requeuePendingMessage(null, this.newDeliveryOption.isSet());
            } else {
                this.showDestination(mbean, this.selectorOrMsgIDArg.getValue(), out);
            }
            out.println();
        }
    }

    public void showDestination(JMSDestinationResourceMBean mbean, String selector, PrintStream out) throws JMSException {
        if (mbean.isQueue()) {
            this.showQueueDest((JMSQueueDestinationResourceMBean)mbean, selector, out);
        } else {
            this.showTopicDest((JMSTopicDestinationResourceMBean)mbean, selector, out);
        }
    }

    private void showQueueDest(JMSQueueDestinationResourceMBean qMbean, String selector, PrintStream out) throws JMSException {
        this.directLogWithSpace("Type: Queue", out);
        this.showDest(qMbean, out);
        int remainingMessages = qMbean.getRemainingMessages();
        this.directLogWithSpace("Remaining messages count:" + remainingMessages, out);
        if (remainingMessages > 0 && this.messageOption.isSet()) {
            this.showMessageInfo(qMbean.getMessageInfo(selector), out);
        }
        remainingMessages = qMbean.getRemainingPendingMessages();
        this.directLogWithSpace("Remaining pending messages count:" + remainingMessages, out);
        if (remainingMessages > 0 && this.pendingMessageOption.isSet()) {
            this.showMessageInfo(qMbean.getPendingMessageInfo(selector), out);
        }
    }

    public void showDest(JMSDestinationResourceMBean destMbean, PrintStream out) {
        this.directLogWithSpace("Destination name:" + destMbean.getName(), out);
        this.directLogWithSpace("Export name:" + destMbean.getExportName(), out);
        List consumers = destMbean.getJMSConsumerResourceNames();
        this.directLogWithSpace("Consumers count:" + consumers.size(), out);
        int index = 0;
        Iterator it = consumers.iterator();
        while (it.hasNext()) {
            out.println("  [" + ++index + "] th :" + it.next());
        }
    }

    private void showTopicDest(JMSTopicDestinationResourceMBean qMbean, String selector, PrintStream out) throws JMSException {
        this.directLogWithSpace("Type: Topic", out);
        this.showDest(qMbean, out);
        List durables = qMbean.getJMSDurableSubscriberResourceNames();
        this.directLogWithSpace("Durable Subscriber count:" + durables.size(), out);
        for (ObjectName durable : durables) {
            JMSDurableSubscriberResourceMBean durMbean = (JMSDurableSubscriberResourceMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)durable, JMSDurableSubscriberResourceMBean.class, (boolean)false);
            this.showDurableSubscriber(durMbean, selector, out);
        }
    }

    public void showDurableSubscriber(JMSDurableSubscriberResourceMBean durableMbean, String selector, PrintStream out) throws JMSException {
        this.directLogWithSpace("Durable Subsciption:", out);
        this.directLogWithSpace("Durable Name:" + durableMbean.getDurableName(), out);
        this.directLogWithSpace("ClientID:" + durableMbean.getClientID(), out);
        this.directLogWithSpace("Selector:" + durableMbean.getSelector(), out);
        int remainingMessages = durableMbean.getRemainingMessages();
        this.directLogWithSpace("Remaining messages count:" + remainingMessages, out);
        if (remainingMessages > 0 && this.messageOption.isSet()) {
            List messageInfos = durableMbean.getMessageInfo(selector);
            this.showMessageInfo(messageInfos, out);
        }
    }
}

