/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSClientResourceMBean;
import jeus.jms.server.mbean.JMSConnectionResourceMBean;
import jeus.jms.server.mbean.JMSConsumerResourceMBean;
import jeus.jms.server.mbean.JMSSessionResourceMBean;
import jeus.jms.server.mbean.stats.JMSClientStatsImpl;
import jeus.jms.server.mbean.stats.JMSConnectionStatsImpl;
import jeus.jms.server.mbean.stats.JMSConsumerStatsImpl;
import jeus.jms.server.mbean.stats.JMSSessionStatsImpl;
import jeus.management.JMXUtility;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.ToggleArguments;

public class JMSEntryCommand
extends JMSCommand {
    private Argument entryIDArg = new Argument("entryID", "entry ID, if the entry is JMSClient-RE1, enter the entrySuffix, RE1");
    private Option connectionOption;
    private Option sessionOption;
    private Option consumerOption;
    private Option destroyOption;

    public JMSEntryCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "entry", "prints information about specific entry or destroy specific entry", utility, container);
        this.registerArgument(this.entryIDArg);
        this.connectionOption = new Option("c", "show connection information");
        this.sessionOption = new Option("s", "show connection and session information");
        this.consumerOption = new Option("e", "show connection, session, and consumer information");
        this.destroyOption = new Option("d", "destroy entry");
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.connectionOption, this.sessionOption, this.consumerOption, this.destroyOption}));
    }

    public void run(PrintStream out) throws Exception {
        String entryID = this.entryIDArg.getValue();
        ObjectName[] names = JMXUtility.queryMBean((MBeanServerConnection)this.utility, (String)this.container, null, (String)"JMSClientResource", null, (String)"Name", (String)("JMSClient-" + entryID));
        if (names == null || names.length == 0) {
            this.directLogWithSpace("No client with entry number of " + entryID, out);
            return;
        }
        if (this.destroyOption.isSet()) {
            this.destroyEntry(names);
        } else {
            this.showEntryInfo(names, out);
        }
    }

    private void destroyEntry(ObjectName[] names) {
        for (int i = 0; i < names.length; ++i) {
            ObjectName name = names[i];
            this.getJMSClientResourceMBean(name).shutdown();
        }
    }

    private void showEntryInfo(ObjectName[] names, PrintStream out) {
        for (int i = 0; i < names.length; ++i) {
            ObjectName name = names[i];
            JMSClientResourceMBean clientMbean = this.getJMSClientResourceMBean(name);
            out.println("  Entry:");
            out.println("  Name:" + JMXUtility.getNameValue((ObjectName)name));
            out.println("  Host Address:" + clientMbean.getHostName());
            out.println("  Port:" + clientMbean.getPort());
            JMSClientStatsImpl stats = (JMSClientStatsImpl)clientMbean.getstats();
            out.println("  Connection count:" + stats.getConnectionCount().getCount());
            if (!this.connectionOption.isSet() && !this.sessionOption.isSet() && !this.consumerOption.isSet()) continue;
            List connections = clientMbean.getJMSConnectionResourceNames();
            this.showConnectionInfo(connections, out);
        }
    }

    private void showConnectionInfo(List connections, PrintStream out) {
        out.println("\t  Connection:");
        if (connections == null || connections.isEmpty()) {
            out.println("\t  Connection does not exist");
            return;
        }
        for (int j = 0; j < connections.size(); ++j) {
            ObjectName _con_name;
            try {
                _con_name = (ObjectName)connections.get(j);
            }
            catch (Exception e) {
                out.println("\t  Cound not make ObjectName with " + connections.get(j));
                continue;
            }
            JMSConnectionResourceMBean conMbean = (JMSConnectionResourceMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)_con_name, JMSConnectionResourceMBean.class, (boolean)false);
            JMSConnectionStatsImpl conStats = (JMSConnectionStatsImpl)conMbean.getstats();
            this.directLogWithSpace("\t  Name:" + JMXUtility.getNameValue((ObjectName)_con_name), out);
            this.directLogWithSpace("\t  Session count:" + conStats.getSessionCount().getCount(), out);
            if (!this.sessionOption.isSet() && !this.consumerOption.isSet()) continue;
            List sessions = conMbean.getJMSSessionResourceNames();
            this.showSessionInfo(sessions, out);
        }
    }

    private void showSessionInfo(List sessions, PrintStream out) {
        out.println("\t\t  Session:");
        if (sessions == null || sessions.isEmpty()) {
            out.println("\t\t  Session does not exist");
            return;
        }
        for (int k = 0; k < sessions.size(); ++k) {
            ObjectName _ses_name;
            try {
                _ses_name = (ObjectName)sessions.get(k);
            }
            catch (Exception e) {
                out.println("\t\t  Cound not make ObjectName with " + sessions.get(k));
                continue;
            }
            JMSSessionResourceMBean sesMbean = (JMSSessionResourceMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)_ses_name, JMSSessionResourceMBean.class, (boolean)false);
            JMSSessionStatsImpl sesStats = (JMSSessionStatsImpl)sesMbean.getstats();
            out.println("\t\t  Name:" + JMXUtility.getNameValue((ObjectName)_ses_name));
            out.println("\t\t  Durable Subscriber Count:" + sesStats.getDurableSubscriptionCount().getCount());
            if (!this.consumerOption.isSet()) continue;
            List endPoints = sesMbean.getJMSEndPointConsumerNames();
            this.showConsumerInfo(endPoints, out);
        }
    }

    private void showConsumerInfo(List endPoints, PrintStream out) {
        out.println("\t\t\t  Consumer:");
        if (endPoints == null || endPoints.isEmpty()) {
            out.println("\t\t\t  Consumer does not exist");
            return;
        }
        for (int i = 0; i < endPoints.size(); ++i) {
            ObjectName _end_name;
            try {
                _end_name = (ObjectName)endPoints.get(i);
            }
            catch (Exception e) {
                out.println("\t\t\t  Cound not make ObjectName with " + endPoints.get(i));
                continue;
            }
            JMSConsumerResourceMBean sesMbean = (JMSConsumerResourceMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)_end_name, JMSConsumerResourceMBean.class, (boolean)false);
            JMSConsumerStatsImpl consStats = (JMSConsumerStatsImpl)sesMbean.getstats();
            out.println("\t\t\t  Name:" + JMXUtility.getNameValue((ObjectName)_end_name));
            out.println("\t\t\t  isDurable:" + sesMbean.isDurable());
            CountStatisticImpl msgCount = (CountStatisticImpl)consStats.getMessageCount();
            CountStatisticImpl pendingCount = (CountStatisticImpl)consStats.getPendingMessageCount();
            out.println("\t\t\t  " + msgCount.getDescription() + ":" + msgCount.getCount());
            out.println("\t\t\t  " + pendingCount.getDescription() + ":" + pendingCount.getCount());
        }
    }

    private JMSClientResourceMBean getJMSClientResourceMBean(ObjectName name) {
        return (JMSClientResourceMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)name, JMSClientResourceMBean.class, (boolean)false);
    }
}

