/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSResourceMBean;
import jeus.jms.server.mbean.JMSServiceChannelMoMBean;
import jeus.management.JMXUtility;
import jeus.util.console.AbstractConsoleUtil;

public class JMSServerCommand
extends JMSCommand {
    public JMSServerCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "server", "print information about connected server", utility, container);
    }

    public void run(PrintStream out) throws Exception {
        JMSResourceMBean jmsMbean = this.getJMSResourceMBean();
        this.showJMSResource(jmsMbean, out);
    }

    public void showJMSResource(JMSResourceMBean jmsMbean, PrintStream out) throws Exception {
        out.println("====<<Memory Info>>====");
        this.directLogWithSpace("Total size : " + jmsMbean.getTotalMemory(), out);
        this.directLogWithSpace("Free size : " + jmsMbean.getFreeMemory(), out);
        List destNames = jmsMbean.getJMSDestinationResourceNames();
        this.showDestination(destNames, true, out);
        List _confAll = jmsMbean.getJMSConnectionFactoryResourceNames();
        this.showConnectionFactory(_confAll, true, out);
        this.showAllEntries(out);
    }

    private void showConnectionFactory(List _confAll, boolean showTitle, PrintStream out) {
        if (_confAll == null || _confAll.size() == 0) {
            if (showTitle) {
                out.println("====<<Factory>>====");
            }
            this.directLogWithSpace("There is no connection factory", out);
        } else {
            if (showTitle) {
                out.println("====<<Factory>>====");
            }
            this.printSortedName(_confAll, out);
        }
    }

    private void showAllEntries(PrintStream out) throws Exception {
        ObjectName[] resources = JMXUtility.findJeusMBean((MBeanServerConnection)this.utility, (String)this.container, (String)"JMSServiceChannel", null);
        if (resources == null) {
            this.directLogWithSpace("No jms server resource was found", out);
            return;
        }
        out.println("====<<Entry>>====");
        for (int i = 0; i < resources.length; ++i) {
            ObjectName name = resources[i];
            JMSServiceChannelMoMBean jmsMbean = (JMSServiceChannelMoMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)name, JMSServiceChannelMoMBean.class, (boolean)false);
            this.showEntryInformation(jmsMbean.getJMSClientResourceNames(), out);
        }
    }

    private void showEntryInformation(String[] _entryAll, PrintStream out) {
        if (_entryAll != null && _entryAll.length != 0) {
            this.printSortedName(_entryAll, out);
        }
    }
}

