/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.util.ListIterator;
import javax.jms.JMSException;
import javax.management.ObjectName;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MultipleMessageHandleEvent;
import jeus.jms.common.message.admin.SingleMessageHandleEvent;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.server.MessageDispatcher;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.mbean.JMSEndPointResource;
import jeus.jms.server.mbean.stats.JMSEndpointStats;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS5;

public abstract class AbstractConsumer
extends MessageDispatcher
implements MessageHandler {
    protected String consumerName;
    protected final long entryID;
    protected final int connectionID;
    protected final int consumerID;
    protected JMSEndPointResource mbean;
    protected JMSEndpointStats stats;

    protected AbstractConsumer(SubscriptionManager manager, long entryID, int connectionID, int consumerID) {
        super(manager);
        this.entryID = entryID;
        this.connectionID = connectionID;
        this.consumerID = consumerID;
    }

    public void handleMessage(MessageContainer packet) throws JMSException {
        AdminMessage message = (AdminMessage)packet;
        if (message.isPublic()) {
            this.handlePublicAdminMessage(message);
            return;
        }
        switch (message.getOperationID()) {
            case 4: {
                this.startConsumer();
                break;
            }
            case 5: {
                this.stopConsumer();
                this.sendReply(message);
                break;
            }
            case 6: {
                this.closeConsumer();
                this.sendReply(message);
                break;
            }
            case 32: {
                this.syncRequest(message);
                break;
            }
            case 33: {
                this.asyncRequest(message);
                break;
            }
            case 34: {
                this.suspendDispatch();
                break;
            }
            case 35: {
                this.resumeDispatch();
                break;
            }
            case 65: {
                this.recover((MultipleMessageHandleEvent)message);
                break;
            }
            case 49: {
                this.recover((SingleMessageHandleEvent)message);
                break;
            }
            case 64: {
                this.returnBack((MultipleMessageHandleEvent)message);
                break;
            }
            case 48: {
                this.returnBack((SingleMessageHandleEvent)message);
                break;
            }
            case 68: {
                this.poisonedMessage((MultipleMessageHandleEvent)message);
                break;
            }
            case 52: {
                this.poisonedMessage((SingleMessageHandleEvent)message);
                break;
            }
            default: {
                throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3100, Byte.toString(message.getOperationID()));
            }
        }
    }

    void handlePublicAdminMessage(AdminMessage message) throws JMSException {
        throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3100, Byte.toString(message.getOperationID()));
    }

    public void handleException(MessageContainer packet, JMSException ex) {
        block3: {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6961_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6961_LEVEL, JeusMessage_JMS5._6961, packet, (Throwable)ex);
            }
            try {
                this.sendFailure(packet, ex);
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6962_LEVEL)) break block3;
                LogUtils.log(logger, JeusMessage_JMS5._6962_LEVEL, JeusMessage_JMS5._6962, packet, (Throwable)e);
            }
        }
    }

    private void recover(MultipleMessageHandleEvent message) {
        ListIterator it = message.getInverseMessageIterator();
        while (it.hasPrevious()) {
            MessageID messageID = (MessageID)it.previous();
            this.recover(messageID);
        }
    }

    private void recover(SingleMessageHandleEvent message) {
        this.recover(message.getMessageID());
    }

    void sendFailure(MessageContainer packet, JMSException e) throws JMSException {
        AdminMessage reply = MessageUtil.createAdminMessage(packet.getMetaHeader());
        reply.setException(e);
        this.sendReply(reply);
    }

    void sendSuccess(MessageContainer packet) throws JMSException {
        AdminMessage reply = MessageUtil.createAdminMessage(packet.getMetaHeader());
        this.sendReply(reply);
    }

    public void activate() throws JMSException {
        try {
            this.registerMBean();
            this.manager.activate(this);
        }
        catch (JMSException e) {
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        this.clearResource();
    }

    public void subscriptionClosed() {
        this.stopConsumer();
    }

    private void clearResource() {
        this.prepareShutdown();
        this.destroyMBean();
    }

    abstract void closeConsumer();

    abstract void registerMBean() throws JMSException;

    synchronized void destroyMBean() {
        if (this.mbean == null) {
            return;
        }
        this.mbean.destroyMBean();
        this.mbean = null;
    }

    public ObjectName getObjectName() {
        return this.mbean == null ? null : this.mbean.getObjectName();
    }

    public long getEntryID() {
        return this.entryID;
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public int getConsumerID() {
        return this.consumerID;
    }

    public JMSEndpointStats getStats() {
        return this.stats;
    }

    public void refresh() {
        this.manager.refesh();
    }

    public String getDigest() {
        return this.consumerName;
    }

    public String toString() {
        return this.consumerName;
    }
}

